/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.v2000.scarads;

import android.content.Context;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.query.AdInfo;
import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.IAdsErrorHandler;
import com.unity3d.scar.adapter.common.IUnityAdsError;
import com.unity3d.scar.adapter.common.scarads.IScarAd;
import com.unity3d.scar.adapter.common.scarads.IScarLoadListener;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.scar.adapter.v2000.scarads.ScarAdListener;
import com.unity3d.scar.adapter.v2000.signals.QueryInfoMetadata;

public abstract class ScarAdBase<T>
implements IScarAd {
    protected T _adObj;
    protected Context _context;
    protected ScarAdMetadata _scarAdMetadata;
    protected QueryInfoMetadata _queryInfoMetadata;
    protected ScarAdListener _scarAdListener;
    protected IAdsErrorHandler _adsErrorHandler;

    public ScarAdBase(Context context, ScarAdMetadata scarAdMetadata, QueryInfoMetadata queryInfoMetadata, IAdsErrorHandler adsErrorHandler) {
        this._context = context;
        this._scarAdMetadata = scarAdMetadata;
        this._queryInfoMetadata = queryInfoMetadata;
        this._adsErrorHandler = adsErrorHandler;
    }

    public void setGmaAd(T rewardedAd) {
        this._adObj = rewardedAd;
    }

    public void loadAd(IScarLoadListener loadListener) {
        if (this._queryInfoMetadata != null) {
            AdInfo adInfo = new AdInfo(this._queryInfoMetadata.getQueryInfo(), this._scarAdMetadata.getAdString());
            AdRequest adRequest = new AdRequest.Builder().setAdInfo(adInfo).build();
            this._scarAdListener.setLoadListener(loadListener);
            this.loadAdInternal(adRequest, loadListener);
        } else {
            this._adsErrorHandler.handleError((IUnityAdsError)GMAAdsError.QueryNotFoundError((ScarAdMetadata)this._scarAdMetadata));
        }
    }

    protected abstract void loadAdInternal(AdRequest var1, IScarLoadListener var2);
}

