/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.ErrorState;
import com.unity3d.services.core.configuration.IInitializationListener;
import com.unity3d.services.core.configuration.IInitializeEventsMetricSender;
import com.unity3d.services.core.configuration.InitializationNotificationCenter;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class InitializeEventsMetricSender
implements IInitializeEventsMetricSender,
IInitializationListener {
    private static InitializeEventsMetricSender _instance;
    private long _startTime = 0L;
    private long _privacyConfigStartTime = 0L;
    private long _privacyConfigEndTime = 0L;
    private long _configStartTime = 0L;
    private int _configRetryCount = 0;
    private int _webviewRetryCount = 0;
    private boolean _initMetricSent = false;
    private boolean _tokenMetricSent = false;

    public static IInitializeEventsMetricSender getInstance() {
        if (_instance == null) {
            _instance = new InitializeEventsMetricSender();
        }
        return _instance;
    }

    private InitializeEventsMetricSender() {
        InitializationNotificationCenter.getInstance().addListener(this);
    }

    @Override
    public void didInitStart() {
        this._startTime = System.nanoTime();
        this._configRetryCount = 0;
        this._webviewRetryCount = 0;
        this.sendMetric(TSIMetric.newInitStarted());
    }

    @Override
    public void didConfigRequestStart() {
        this._configStartTime = System.nanoTime();
    }

    @Override
    public void didPrivacyConfigRequestStart() {
        this._privacyConfigStartTime = System.nanoTime();
    }

    @Override
    public void didPrivacyConfigRequestEnd(boolean success) {
        this._privacyConfigEndTime = System.nanoTime();
        this.sendPrivacyResolutionRequestIfNeeded(success);
    }

    @Override
    public synchronized void sdkDidInitialize() {
        if (this.initializationStartTimeStamp() == 0L) {
            DeviceLog.debug("sdkDidInitialize called before didInitStart, skipping metric");
            return;
        }
        if (!this._initMetricSent) {
            this.sendMetric(TSIMetric.newInitTimeSuccess(this.duration(), this.getRetryTags()));
            this._initMetricSent = true;
        }
    }

    @Override
    public Long initializationStartTimeStamp() {
        return this._startTime;
    }

    @Override
    public synchronized void sdkInitializeFailed(String message, ErrorState errorState) {
        if (this._startTime == 0L) {
            DeviceLog.debug("sdkInitializeFailed called before didInitStart, skipping metric");
            return;
        }
        if (!this._initMetricSent) {
            this.sendMetric(TSIMetric.newInitTimeFailure(this.duration(), this.getErrorStateTags(errorState)));
            this._initMetricSent = true;
        }
    }

    @Override
    public synchronized void sdkTokenDidBecomeAvailableWithConfig(boolean withConfig) {
        if (!this._tokenMetricSent) {
            this.sendTokenAvailabilityMetricWithConfig(withConfig);
            if (withConfig) {
                this.sendTokenResolutionRequestMetricIfNeeded();
            }
            this._tokenMetricSent = true;
        }
    }

    private void sendTokenAvailabilityMetricWithConfig(boolean withConfig) {
        if (this._startTime == 0L) {
            DeviceLog.debug("sendTokenAvailabilityMetricWithConfig called before didInitStart, skipping metric");
            return;
        }
        Long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this._startTime);
        Map<String, String> tags = this.getRetryTags();
        Metric metric = withConfig ? TSIMetric.newTokenAvailabilityLatencyConfig(duration, tags) : TSIMetric.newTokenAvailabilityLatencyWebview(duration, tags);
        this.sendMetric(metric);
    }

    private void sendTokenResolutionRequestMetricIfNeeded() {
        if (this._configStartTime == 0L) {
            DeviceLog.debug("sendTokenResolutionRequestMetricIfNeeded called before didInitStart, skipping metric");
            return;
        }
        this.sendMetric(TSIMetric.newTokenResolutionRequestLatency(this.tokenDuration(), this.getRetryTags()));
    }

    private void sendPrivacyResolutionRequestIfNeeded(boolean success) {
        if (this._privacyConfigStartTime == 0L || this._privacyConfigEndTime == 0L) {
            DeviceLog.debug("sendTokenResolutionRequestMetricIfNeeded called before didInitStart, skipping metric");
            return;
        }
        if (success) {
            this.sendMetric(TSIMetric.newPrivacyResolutionRequestLatencySuccess(this.privacyConfigDuration()));
        } else {
            this.sendMetric(TSIMetric.newPrivacyResolutionRequestLatencyFailure(this.privacyConfigDuration()));
        }
    }

    @Override
    public void onRetryConfig() {
        ++this._configRetryCount;
    }

    @Override
    public void onRetryWebview() {
        ++this._webviewRetryCount;
    }

    @Override
    public Long duration() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this._startTime);
    }

    @Override
    public Long tokenDuration() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this._configStartTime);
    }

    @Override
    public Long privacyConfigDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this._privacyConfigEndTime - this._privacyConfigStartTime);
    }

    public Map<String, String> getErrorStateTags(ErrorState errorState) {
        Map<String, String> tags = this.getRetryTags();
        tags.put("stt", errorState.getMetricName());
        return tags;
    }

    @Override
    public Map<String, String> getRetryTags() {
        return new HashMap<String, String>(){
            {
                this.put("c_retry", String.valueOf(InitializeEventsMetricSender.this._configRetryCount));
                this.put("wv_retry", String.valueOf(InitializeEventsMetricSender.this._webviewRetryCount));
            }
        };
    }

    @Override
    public void sendMetric(Metric metric) {
        SDKMetrics.getInstance().sendMetric(metric);
    }

    @Override
    public void onSdkInitialized() {
        this.sdkDidInitialize();
    }

    @Override
    public void onSdkInitializationFailed(String message, ErrorState errorState, int code) {
        this.sdkInitializeFailed(message, errorState);
    }
}

