/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationRequestFactory;
import com.unity3d.services.core.configuration.IConfigurationLoader;
import com.unity3d.services.core.configuration.IConfigurationLoaderListener;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import org.json.JSONObject;

public class ConfigurationLoader
implements IConfigurationLoader {
    private final Configuration _localConfiguration;
    private final ConfigurationRequestFactory _configurationRequestFactory;

    public ConfigurationLoader(ConfigurationRequestFactory configurationRequestFactory) {
        this._localConfiguration = configurationRequestFactory.getConfiguration();
        this._configurationRequestFactory = configurationRequestFactory;
    }

    @Override
    public void loadConfiguration(IConfigurationLoaderListener configurationLoaderListener) throws Exception {
        boolean is2XXResponseCode;
        WebRequest request;
        try {
            request = this._configurationRequestFactory.getWebRequest();
        }
        catch (Exception ex) {
            configurationLoaderListener.onError("Could not create web request: " + ex);
            return;
        }
        InitializeEventsMetricSender.getInstance().didConfigRequestStart();
        String data = request.makeRequest();
        boolean bl = is2XXResponseCode = request.getResponseCode() / 100 == 2;
        if (!is2XXResponseCode) {
            configurationLoaderListener.onError("Non 2xx HTTP status received from ads configuration request.");
            return;
        }
        try {
            this._localConfiguration.handleConfigurationData(new JSONObject(data), true);
        }
        catch (Exception e) {
            configurationLoaderListener.onError("Could not create web request");
            return;
        }
        this.sendConfigMetrics(this._localConfiguration.getUnifiedAuctionToken(), this._localConfiguration.getStateId());
        configurationLoaderListener.onSuccess(this._localConfiguration);
    }

    @Override
    public Configuration getLocalConfiguration() {
        return this._localConfiguration;
    }

    private void sendConfigMetrics(String unifiedAuctionToken, String stateId) {
        if (this._localConfiguration.getExperiments() != null && this._localConfiguration.getExperiments().isTwoStageInitializationEnabled()) {
            if (unifiedAuctionToken == null || unifiedAuctionToken.isEmpty()) {
                SDKMetrics.getInstance().sendMetric(TSIMetric.newMissingToken());
            }
            if (stateId == null || stateId.isEmpty()) {
                SDKMetrics.getInstance().sendMetric(TSIMetric.newMissingStateId());
            }
        }
    }
}

