/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import com.unity3d.ads.UnityAds;
import com.unity3d.services.core.request.metrics.AdOperationError;
import com.unity3d.services.core.request.metrics.Metric;
import java.util.HashMap;

public class AdOperationMetric {
    private static final String AD_LOAD_START = "native_load_started";
    private static final String AD_SHOW_START = "native_show_started";
    private static final String AD_LOAD_SUCCESS = "native_load_time_success";
    private static final String AD_SHOW_SUCCESS = "native_show_time_success";
    private static final String AD_LOAD_FAIL = "native_load_time_failure";
    private static final String AD_SHOW_FAIL = "native_show_time_failure";
    private static final String AD_LOAD_TYPE = "type";
    private static final String AD_IS_HEADER_BIDDING = "is_header_bidding";
    private static final String UNKNOWN = "unknown";
    public static final String REASON = "reason";
    public static final String INIT_STATE = "state";
    private static final String AD_TYPE_BANNER = "banner";
    private static final String AD_TYPE_VIDEO = "video";

    public static Metric newAdLoadStart(boolean isBanner, boolean isHb) {
        return new Metric(AD_LOAD_START, null, AdOperationMetric.getTags(null, false, isBanner, isHb));
    }

    public static Metric newAdShowStart() {
        return new Metric(AD_SHOW_START, null, AdOperationMetric.getTags(null, false, false, null));
    }

    public static Metric newAdLoadSuccess(Long durationMs, boolean isBanner, boolean isHb) {
        return new Metric(AD_LOAD_SUCCESS, durationMs, AdOperationMetric.getTags(null, false, isBanner, isHb));
    }

    public static Metric newAdShowSuccess(Long durationMs) {
        return new Metric(AD_SHOW_SUCCESS, durationMs, AdOperationMetric.getTags(null, false, false, null));
    }

    public static Metric newAdLoadFailure(AdOperationError error2, Long durationMs, boolean isBanner, boolean isHb) {
        return new Metric(AD_LOAD_FAIL, durationMs, AdOperationMetric.getTags(error2, true, isBanner, isHb));
    }

    public static Metric newAdLoadFailure(UnityAds.UnityAdsLoadError error2, Long durationMs, boolean isBanner, boolean isHb) {
        return AdOperationMetric.newAdLoadFailure(AdOperationMetric.mapUnityAdsLoadError(error2), durationMs, isBanner, isHb);
    }

    public static Metric newAdShowFailure(AdOperationError error2, Long durationMs) {
        return new Metric(AD_SHOW_FAIL, durationMs, AdOperationMetric.getTags(error2, true, false, null));
    }

    public static Metric newAdShowFailure(UnityAds.UnityAdsShowError error2, Long durationMs) {
        return AdOperationMetric.newAdShowFailure(AdOperationMetric.mapUnityAdsShowError(error2), durationMs);
    }

    private static HashMap<String, String> getTags(AdOperationError error2, final boolean isFailure, boolean isBanner, final Boolean isHb) {
        final String errorMetric = error2 == null ? UNKNOWN : error2.toString();
        final String type = isBanner ? AD_TYPE_BANNER : AD_TYPE_VIDEO;
        return new HashMap<String, String>(){
            {
                if (isFailure) {
                    this.put(AdOperationMetric.REASON, errorMetric);
                }
                this.put(AdOperationMetric.AD_LOAD_TYPE, type);
                if (isHb != null) {
                    this.put(AdOperationMetric.AD_IS_HEADER_BIDDING, String.valueOf(isHb));
                }
            }
        };
    }

    private static AdOperationError mapUnityAdsLoadError(UnityAds.UnityAdsLoadError error2) {
        switch (error2) {
            case INITIALIZE_FAILED: {
                return AdOperationError.init_failed;
            }
            case INTERNAL_ERROR: {
                return AdOperationError.internal;
            }
            case INVALID_ARGUMENT: {
                return AdOperationError.invalid;
            }
            case NO_FILL: {
                return AdOperationError.no_fill;
            }
            case TIMEOUT: {
                return AdOperationError.timeout;
            }
        }
        return null;
    }

    private static AdOperationError mapUnityAdsShowError(UnityAds.UnityAdsShowError error2) {
        switch (error2) {
            case NOT_INITIALIZED: {
                return AdOperationError.init_failed;
            }
            case NOT_READY: {
                return AdOperationError.not_ready;
            }
            case VIDEO_PLAYER_ERROR: {
                return AdOperationError.player;
            }
            case INVALID_ARGUMENT: {
                return AdOperationError.invalid;
            }
            case NO_CONNECTION: {
                return AdOperationError.no_connection;
            }
            case ALREADY_SHOWING: {
                return AdOperationError.already_showing;
            }
            case INTERNAL_ERROR: {
                return AdOperationError.internal;
            }
        }
        return null;
    }
}

