/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import com.unity3d.services.core.device.StorageEvent;
import com.unity3d.services.core.device.StorageEventInfo;
import com.unity3d.services.core.device.StorageManager;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.JsonStorage;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0013\u001a\u00020\nJ\b\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/unity3d/services/core/device/Storage;", "Lcom/unity3d/services/core/misc/JsonStorage;", "_targetFileName", "", "type", "Lcom/unity3d/services/core/device/StorageManager$StorageType;", "(Ljava/lang/String;Lcom/unity3d/services/core/device/StorageManager$StorageType;)V", "getType", "()Lcom/unity3d/services/core/device/StorageManager$StorageType;", "clearStorage", "", "initStorage", "readStorage", "sendEvent", "", "eventType", "Lcom/unity3d/services/core/device/StorageEvent;", "value", "", "storageFileExists", "writeStorage", "Companion", "unity-ads_defaultRelease"})
@SourceDebugExtension(value={"SMAP\nStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Storage.kt\ncom/unity3d/services/core/device/Storage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1855#2,2:99\n*S KotlinDebug\n*F\n+ 1 Storage.kt\ncom/unity3d/services/core/device/Storage\n*L\n76#1:99,2\n*E\n"})
public class Storage
extends JsonStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String _targetFileName;
    @NotNull
    private final StorageManager.StorageType type;
    @NotNull
    private static final MutableStateFlow<List<Function1<StorageEventInfo, Unit>>> onStorageEventCallbacks = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());

    public Storage(@NotNull String _targetFileName, @NotNull StorageManager.StorageType type) {
        Intrinsics.checkNotNullParameter((Object)_targetFileName, (String)"_targetFileName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this._targetFileName = _targetFileName;
        this.type = type;
    }

    @NotNull
    public final StorageManager.StorageType getType() {
        return this.type;
    }

    public synchronized boolean readStorage() {
        boolean bl;
        File f = new File(this._targetFileName);
        try {
            byte[] byArray = Utilities.readFileBytes(f);
            if (byArray == null) {
                return false;
            }
            byte[] bytes = byArray;
            String fileData = new String(bytes, Charsets.UTF_8);
            this.setData(new JSONObject(fileData));
            bl = true;
        }
        catch (FileNotFoundException e) {
            Object[] objectArray = new Object[]{e};
            DeviceLog.debug("Storage JSON file not found in local cache:", objectArray);
            bl = false;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e};
            DeviceLog.debug("Failed to read storage JSON file:", objectArray);
            bl = false;
        }
        return bl;
    }

    public final synchronized boolean initStorage() {
        this.readStorage();
        super.initData();
        return true;
    }

    public synchronized boolean writeStorage() {
        File f = new File(this._targetFileName);
        if (this.getData() != null) {
            boolean success2 = false;
            success2 = Utilities.writeFile(f, this.getData().toString());
            return success2;
        }
        return false;
    }

    public synchronized boolean clearStorage() {
        this.clearData();
        File f = new File(this._targetFileName);
        return f.delete();
    }

    public final synchronized boolean storageFileExists() {
        File f = new File(this._targetFileName);
        return f.exists();
    }

    public final synchronized void sendEvent(@Nullable StorageEvent eventType, @Nullable Object value) {
        List callbacks = (List)onStorageEventCallbacks.getValue();
        if (!((Collection)callbacks).isEmpty()) {
            StorageEvent storageEvent = eventType;
            Intrinsics.checkNotNull((Object)((Object)storageEvent));
            StorageEventInfo event = new StorageEventInfo(storageEvent, this.type, value);
            Iterable $this$forEach$iv = callbacks;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 it = (Function1)element$iv;
                boolean bl = false;
                it.invoke((Object)event);
            }
            return;
        }
        boolean success2 = false;
        if (WebViewApp.getCurrentApp() != null) {
            Object[] objectArray = new Object[]{this.type.name(), value};
            success2 = WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORAGE, eventType, objectArray);
        }
        if (!success2) {
            DeviceLog.debug("Couldn't send storage event to WebApp");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006J\u001a\u0010\u000b\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006R&\u0010\u0003\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/unity3d/services/core/device/Storage$Companion;", "", "()V", "onStorageEventCallbacks", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lkotlin/Function1;", "Lcom/unity3d/services/core/device/StorageEventInfo;", "", "addStorageEventCallback", "callback", "removeStorageEventCallback", "unity-ads_defaultRelease"})
    @SourceDebugExtension(value={"SMAP\nStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Storage.kt\ncom/unity3d/services/core/device/Storage$Companion\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,98:1\n230#2,5:99\n230#2,5:104\n*S KotlinDebug\n*F\n+ 1 Storage.kt\ncom/unity3d/services/core/device/Storage$Companion\n*L\n94#1:99,5\n95#1:104,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void addStorageEventCallback(@NotNull Function1<? super StorageEventInfo, Unit> callback2) {
            List it;
            List nextValue$iv;
            Object prevValue$iv;
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            MutableStateFlow $this$update$iv = onStorageEventCallbacks;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (List)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CollectionsKt.plus((Collection)it, callback2))));
        }

        public final void removeStorageEventCallback(@NotNull Function1<? super StorageEventInfo, Unit> callback2) {
            List it;
            List nextValue$iv;
            Object prevValue$iv;
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            MutableStateFlow $this$update$iv = onStorageEventCallbacks;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (List)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CollectionsKt.minus((Iterable)it, callback2))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

