/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import android.annotation.TargetApi;
import android.media.MediaMetadataRetriever;
import android.util.Base64;
import android.util.SparseArray;
import com.unity3d.services.core.api.Request;
import com.unity3d.services.core.cache.CacheDirectory;
import com.unity3d.services.core.cache.CacheDirectoryType;
import com.unity3d.services.core.cache.CacheError;
import com.unity3d.services.core.cache.CacheThread;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequestError;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Cache {
    @WebViewExposed
    public static void download(String url, String fileId, JSONArray headers, Boolean append, WebViewCallback callback2) {
        HashMap<String, List<String>> mappedHeaders;
        if (CacheThread.isActive()) {
            callback2.error(CacheError.FILE_ALREADY_CACHING, new Object[0]);
            return;
        }
        if (!Device.isActiveNetworkConnected()) {
            callback2.error(CacheError.NO_INTERNET, new Object[0]);
            return;
        }
        try {
            mappedHeaders = Request.getHeadersMap(headers);
        }
        catch (Exception e) {
            DeviceLog.exception("Error mapping headers for the request", e);
            callback2.error(WebRequestError.MAPPING_HEADERS_FAILED, url, fileId);
            return;
        }
        CacheThread.download(url, Cache.fileIdToFilename(fileId), mappedHeaders, append, SharedInstances.INSTANCE.getWebViewEventSender());
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void stop(WebViewCallback callback2) {
        if (!CacheThread.isActive()) {
            callback2.error(CacheError.NOT_CACHING, new Object[0]);
            return;
        }
        CacheThread.cancel();
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void isCaching(WebViewCallback callback2) {
        callback2.invoke(CacheThread.isActive());
    }

    @WebViewExposed
    public static void getFileContent(String fileId, String encoding, WebViewCallback callback2) {
        String fileContents;
        byte[] byteData;
        String fileName = Cache.fileIdToFilename(fileId);
        File f = new File(fileName);
        if (!f.exists()) {
            callback2.error(CacheError.FILE_NOT_FOUND, fileId, fileName);
            return;
        }
        try {
            byteData = Utilities.readFileBytes(f);
        }
        catch (IOException e) {
            callback2.error(CacheError.FILE_IO_ERROR, fileId, fileName, e.getMessage() + ", " + e.getClass().getName());
            return;
        }
        if (encoding == null) {
            callback2.error(CacheError.UNSUPPORTED_ENCODING, fileId, fileName, encoding);
            return;
        }
        if (encoding.equals("UTF-8")) {
            ByteBuffer buf = ByteBuffer.wrap(byteData);
            CharBuffer charbuffer = Charset.forName("UTF-8").decode(buf);
            fileContents = charbuffer.toString();
        } else if (encoding.equals("Base64")) {
            fileContents = Base64.encodeToString((byte[])byteData, (int)2);
        } else {
            callback2.error(CacheError.UNSUPPORTED_ENCODING, fileId, fileName, encoding);
            return;
        }
        callback2.invoke(fileContents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebViewExposed
    public static void setFileContent(String fileId, String encoding, String content, WebViewCallback callback2) {
        byte[] fileContents;
        String targetFileName = Cache.fileIdToFilename(fileId);
        FileOutputStream fileOutput = null;
        boolean success2 = false;
        try {
            fileContents = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            callback2.error(CacheError.UNSUPPORTED_ENCODING, fileId, targetFileName, encoding);
            return;
        }
        if (encoding != null && encoding.length() > 0) {
            if (encoding.equals("Base64")) {
                fileContents = Base64.decode((String)content, (int)2);
            } else if (!encoding.equals("UTF-8")) {
                callback2.error(CacheError.UNSUPPORTED_ENCODING, fileId, targetFileName, encoding);
                return;
            }
        }
        try {
            fileOutput = new FileOutputStream(targetFileName);
            fileOutput.write(fileContents);
            fileOutput.flush();
            success2 = true;
        }
        catch (FileNotFoundException e) {
            callback2.error(CacheError.FILE_NOT_FOUND, fileId, targetFileName, encoding);
        }
        catch (IOException e) {
            callback2.error(CacheError.FILE_IO_ERROR, fileId, targetFileName, encoding);
        }
        finally {
            try {
                if (fileOutput != null) {
                    fileOutput.close();
                }
            }
            catch (Exception e) {
                DeviceLog.exception("Error closing FileOutputStream", e);
            }
        }
        if (success2) {
            callback2.invoke(new Object[0]);
        }
    }

    @WebViewExposed
    public static void getFiles(WebViewCallback callback2) {
        File cacheDirectory = SdkProperties.getCacheDirectory();
        if (cacheDirectory == null) {
            return;
        }
        DeviceLog.debug("Unity Ads cache: checking app directory for Unity Ads cached files");
        FilenameFilter filter2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(SdkProperties.getCacheFilePrefix());
            }
        };
        File[] fileList = cacheDirectory.listFiles(filter2);
        if (fileList == null || fileList.length == 0) {
            callback2.invoke(new JSONArray());
        }
        try {
            JSONArray files = new JSONArray();
            for (File f : fileList) {
                String name = f.getName().substring(SdkProperties.getCacheFilePrefix().length());
                DeviceLog.debug("Unity Ads cache: found " + name + ", " + f.length() + " bytes");
                files.put((Object)Cache.getFileJson(name));
            }
            callback2.invoke(files);
        }
        catch (JSONException e) {
            DeviceLog.exception("Error creating JSON", (Exception)((Object)e));
            callback2.error(CacheError.JSON_ERROR, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getFileInfo(String fileId, WebViewCallback callback2) {
        try {
            JSONObject result2 = Cache.getFileJson(fileId);
            callback2.invoke(result2);
        }
        catch (JSONException e) {
            DeviceLog.exception("Error creating JSON", (Exception)((Object)e));
            callback2.error(CacheError.JSON_ERROR, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getFilePath(String fileId, WebViewCallback callback2) {
        File f = new File(Cache.fileIdToFilename(fileId));
        if (f.exists()) {
            callback2.invoke(Cache.fileIdToFilename(fileId));
        } else {
            callback2.error(CacheError.FILE_NOT_FOUND, new Object[0]);
        }
    }

    @WebViewExposed
    public static void deleteFile(String fileId, WebViewCallback callback2) {
        File file = new File(Cache.fileIdToFilename(fileId));
        if (file.delete()) {
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(CacheError.FILE_IO_ERROR, new Object[0]);
        }
    }

    @WebViewExposed
    public static void getHash(String fileId, WebViewCallback callback2) {
        callback2.invoke(Utilities.Sha256(fileId));
    }

    @WebViewExposed
    public static void setTimeouts(Integer connectTimeout, Integer readTimeout, WebViewCallback callback2) {
        CacheThread.setConnectTimeout(connectTimeout);
        CacheThread.setReadTimeout(readTimeout);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getTimeouts(WebViewCallback callback2) {
        callback2.invoke(CacheThread.getConnectTimeout(), CacheThread.getReadTimeout());
    }

    @WebViewExposed
    public static void setProgressInterval(Integer interval, WebViewCallback callback2) {
        CacheThread.setProgressInterval(interval);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getProgressInterval(WebViewCallback callback2) {
        callback2.invoke(CacheThread.getProgressInterval());
    }

    @WebViewExposed
    public static void getFreeSpace(WebViewCallback callback2) {
        callback2.invoke(Device.getFreeSpace(SdkProperties.getCacheDirectory()));
    }

    @WebViewExposed
    public static void getTotalSpace(WebViewCallback callback2) {
        callback2.invoke(Device.getTotalSpace(SdkProperties.getCacheDirectory()));
    }

    @WebViewExposed
    public static void getMetaData(String fileId, JSONArray requestedMetaDatas, WebViewCallback callback2) {
        SparseArray<String> returnValues;
        String videoFile = Cache.fileIdToFilename(fileId);
        try {
            returnValues = Cache.getMetaData(videoFile, requestedMetaDatas);
        }
        catch (JSONException e) {
            callback2.error(CacheError.JSON_ERROR, e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            callback2.error(CacheError.INVALID_ARGUMENT, e.getMessage());
            return;
        }
        catch (IOException e) {
            callback2.error(CacheError.FILE_IO_ERROR, e.getMessage());
            return;
        }
        JSONArray returnJsonArray = new JSONArray();
        for (int i = 0; i < returnValues.size(); ++i) {
            JSONArray entryJsonArray = new JSONArray();
            entryJsonArray.put(returnValues.keyAt(i));
            entryJsonArray.put(returnValues.valueAt(i));
            returnJsonArray.put((Object)entryJsonArray);
        }
        callback2.invoke(returnJsonArray);
    }

    @WebViewExposed
    public static void getCacheDirectoryType(WebViewCallback callback2) {
        CacheDirectory cacheDir = SdkProperties.getCacheDirectoryObject();
        if (cacheDir == null || cacheDir.getCacheDirectory(ClientProperties.getApplicationContext()) == null) {
            callback2.error(CacheError.CACHE_DIRECTORY_NULL, new Object[0]);
            return;
        }
        if (!cacheDir.getCacheDirectory(ClientProperties.getApplicationContext()).exists()) {
            callback2.error(CacheError.CACHE_DIRECTORY_DOESNT_EXIST, new Object[0]);
            return;
        }
        CacheDirectoryType cacheDirType = cacheDir.getType();
        if (cacheDirType == null) {
            callback2.error(CacheError.CACHE_DIRECTORY_TYPE_NULL, new Object[0]);
            return;
        }
        callback2.invoke(cacheDirType.name());
    }

    @WebViewExposed
    public static void getCacheDirectoryExists(WebViewCallback callback2) {
        File cacheDir = SdkProperties.getCacheDirectory();
        if (cacheDir == null) {
            callback2.error(CacheError.CACHE_DIRECTORY_NULL, new Object[0]);
            return;
        }
        callback2.invoke(cacheDir.exists());
    }

    @WebViewExposed
    public static void recreateCacheDirectory(WebViewCallback callback2) {
        File cacheDir = SdkProperties.getCacheDirectory();
        if (cacheDir.exists()) {
            callback2.error(CacheError.CACHE_DIRECTORY_EXISTS, new Object[0]);
            return;
        }
        SdkProperties.setCacheDirectory(null);
        cacheDir = SdkProperties.getCacheDirectory();
        if (cacheDir == null) {
            callback2.error(CacheError.CACHE_DIRECTORY_NULL, new Object[0]);
            return;
        }
        callback2.invoke(new Object[0]);
    }

    @TargetApi(value=10)
    private static SparseArray<String> getMetaData(String videoFile, JSONArray requestedMetaDatas) throws JSONException, IOException, RuntimeException {
        File f = new File(videoFile);
        SparseArray returnArray = new SparseArray();
        if (f.exists()) {
            MediaMetadataRetriever metadataRetriever = new MediaMetadataRetriever();
            metadataRetriever.setDataSource(f.getAbsolutePath());
            for (int i = 0; i < requestedMetaDatas.length(); ++i) {
                int metaDataKey = requestedMetaDatas.getInt(i);
                String metaDataValue = metadataRetriever.extractMetadata(metaDataKey);
                if (metaDataValue == null) continue;
                returnArray.put(metaDataKey, (Object)metaDataValue);
            }
        } else {
            throw new IOException("File: " + f.getAbsolutePath() + " doesn't exist");
        }
        return returnArray;
    }

    private static String fileIdToFilename(String fileId) {
        if (SdkProperties.getCacheDirectory() == null) {
            return "";
        }
        return SdkProperties.getCacheDirectory() + "/" + SdkProperties.getCacheFilePrefix() + fileId;
    }

    private static JSONObject getFileJson(String fileId) throws JSONException {
        JSONObject fileJson = new JSONObject();
        fileJson.put("id", (Object)fileId);
        File f = new File(Cache.fileIdToFilename(fileId));
        if (f.exists()) {
            fileJson.put("found", true);
            fileJson.put("size", f.length());
            fileJson.put("mtime", f.lastModified());
        } else {
            fileJson.put("found", false);
        }
        return fileJson;
    }
}

