package com.unity3d.services.core.fid

import com.google.android.gms.tasks.Task
import com.google.android.gms.tasks.Tasks
import com.unity3d.services.core.reflection.GenericBridge

class FIdBridge(private val instance: Any) :
    GenericBridge(mapOf(
            Pair(Constants.GET_APP_INSTANCE_ID, arrayOf<Class<*>>())
    ), false) {

    override fun getClassName(): String {
        return Constants.getClassName()
    }

    fun getAppInstanceId(): Task<String?> {
        return callNonVoidMethod<Task<String?>>(
            Constants.GET_APP_INSTANCE_ID,
            instance
        ) ?: Tasks.forResult(null)
    }
}