package com.unity3d.services.store.gpbl.bridges.billingclient

import android.content.Context
import com.unity3d.services.store.gpbl.bridges.billingclient.v8.QueryProductDetailsResultsBridge

class BillingClientAdapterFactory {
    fun createBillingClientAdapter(context: Context): BillingClientAdapter? {
        return createV8Adapter(context)
            .getOrElse { error ->
                if (error is FallbackException) {
                    createV6Adapter(context, error.detectedVersion)
                } else {
                    createV6Adapter(context)
                }
            }
    }

    private fun createV8Adapter(context: Context): Result<BillingClientAdapter> {
        return runCatching {
            val builder = com.unity3d.services.store.gpbl.bridges.billingclient.v8.BillingClientBridge.newBuilder(context)
            val billingClientAdapter = com.unity3d.services.store.gpbl.bridges.billingclient.v8.BillingClientAdapter(builder)

            // Check if v8 features are available, if not its v7 and we expect to fallback to v6 adapter
            if (!QueryProductDetailsResultsBridge(Any()).exists()) {
                throw FallbackException(7)
            }

            billingClientAdapter
        }
    }

    private fun createV6Adapter(context: Context,
                                fallbackVersion: Int = 6): BillingClientAdapter? {
        return runCatching {
            val builder = com.unity3d.services.store.gpbl.bridges.billingclient.v6.BillingClientBridge.newBuilder(context)
            com.unity3d.services.store.gpbl.bridges.billingclient.v6.BillingClientAdapter(builder, fallbackVersion)
        }.getOrNull()
    }
}