package com.unity3d.ads.core.domain

import android.content.Context
import com.google.protobuf.ByteString
import com.unity3d.ads.adplayer.AdPlayer
import com.unity3d.ads.adplayer.AndroidEmbeddableWebViewAdPlayer
import com.unity3d.ads.adplayer.AndroidFullscreenWebViewAdPlayer
import com.unity3d.ads.adplayer.AndroidWebViewContainer
import com.unity3d.ads.adplayer.WebViewAdPlayer
import com.unity3d.ads.adplayer.WebViewBridge
import com.unity3d.ads.core.data.datasource.LifecycleDataSource
import com.unity3d.ads.core.data.manager.OfferwallManager
import com.unity3d.ads.core.data.manager.ScarManager
import com.unity3d.ads.core.data.model.CoroutineOpportunity
import com.unity3d.ads.core.data.repository.AdRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.data.repository.OrientationRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.extensions.toUUID
import gatewayprotocol.v1.DiagnosticEventRequestOuterClass.DiagnosticAdType
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.plus

internal class CommonGetAdPlayer(
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent,
    private val defaultDispatcher: CoroutineDispatcher,
    private val adPlayerScope: CoroutineScope,
    private val openMeasurementRepository: OpenMeasurementRepository,
    private val scarManager: ScarManager,
    private val offerwallManager: OfferwallManager,
    private val adRepository: AdRepository,
    private val lifecycleDataSource: LifecycleDataSource,
    private val orientationRepository: OrientationRepository,
    private val context: Context,
) : GetAdPlayer {

    override fun invoke(
        webviewBridge: WebViewBridge,
        webviewContainer: AndroidWebViewContainer,
        opportunityId: ByteString,
        adType: DiagnosticAdType
    ): AdPlayer {

        // Add the opportunityId inside the adPlayerScope
        val scopeWithOpportunityId = adPlayerScope + CoroutineOpportunity(opportunityId)

        val webViewAdPlayer = WebViewAdPlayer(
            webviewBridge,
            deviceInfoRepository,
            sessionRepository,
            defaultDispatcher,
            sendDiagnosticEvent,
            webviewContainer,
            scopeWithOpportunityId,
        )

        return if (adType == DiagnosticAdType.DIAGNOSTIC_AD_TYPE_FULLSCREEN)
            AndroidFullscreenWebViewAdPlayer(
                webViewAdPlayer = webViewAdPlayer,
                webViewContainer = webviewContainer,
                opportunityId = opportunityId.toUUID().toString(),
                deviceInfoRepository = deviceInfoRepository,
                sessionRepository = sessionRepository,
                openMeasurementRepository = openMeasurementRepository,
                scarManager = scarManager,
                offerwallManager = offerwallManager,
                sendDiagnosticEvent = sendDiagnosticEvent,
                adRepository = adRepository,
                orientationRepository = orientationRepository,
                context = context,
            ) else
            AndroidEmbeddableWebViewAdPlayer(
                webViewAdPlayer = webViewAdPlayer,
                webViewContainer = webviewContainer,
                opportunityId = opportunityId.toUUID().toString(),
                openMeasurementRepository = openMeasurementRepository,
                scarManager = scarManager,
                lifecycleDataSource = lifecycleDataSource,
                context = context,
            )
    }
}