package com.unity3d.ads.core.data.manager

import android.content.Context
import com.unity3d.ads.core.domain.scar.GmaEventData
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata
import com.unity3d.services.ads.gmascar.models.BiddingSignals
import com.unity3d.services.banners.BannerView
import com.unity3d.services.banners.UnityBannerSize
import gatewayprotocol.v1.AdFormatOuterClass.AdFormat
import kotlinx.coroutines.flow.Flow

interface ScarManager {
    suspend fun getVersion(): String?
    suspend fun getSignals(adFormat: List<AdFormat>?): BiddingSignals?
    suspend fun loadAd(adFormat: String, placementId: String, adString: String, adUnitId: String, queryId: String, videoLength: Int)
    fun loadBannerAd(context: Context,
                     bannerView: BannerView,
                     scarAdMetadata: ScarAdMetadata,
                     bannerSize: UnityBannerSize,
                     opportunityId: String): Flow<GmaEventData>
    fun show(placementId: String, queryId: String): Flow<GmaEventData>
}