package com.unity3d.ads.adplayer

import android.view.InputEvent
import kotlinx.coroutines.flow.StateFlow
import org.json.JSONArray

interface WebViewContainer {
    suspend fun loadUrl(url: String)
    suspend fun evaluateJavascript(handlerType: HandlerType, arguments: JSONArray)
    suspend fun addJavascriptInterface(webViewBridgeInterface: WebViewBridge, name: String)
    suspend fun destroy()

    val lastInputEvent: StateFlow<InputEvent?>
}
