package com.unity3d.ads.core.domain.billing

import com.unity3d.services.store.gpbl.bridges.BillingResultBridge

/**
 * Result of a product details fetch operation.
 */
sealed class ProductDetailsResult {
    data class Success(val productDetailsJson: String) : ProductDetailsResult()
    data class Failure(val billingResult: BillingResultBridge) : ProductDetailsResult()
    object NotFound : ProductDetailsResult()
}


