/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.load;

import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.AdModule;
import com.unity3d.services.ads.operation.load.ILoadModule;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadOperation;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.AdOperationError;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import com.unity3d.services.core.webview.bridge.invocation.WebViewBridgeInvocation;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseLoadModule
extends AdModule<ILoadOperation, LoadOperationState>
implements ILoadModule {
    static final String errorMsgInternalCommunicationFailure = "[UnityAds] Internal communication failure";
    static final String errorMsgInternalCommunicationTimeout = "[UnityAds] Internal communication timeout";
    static final String errorMsgPlacementIdNull = "[UnityAds] Placement ID cannot be null";
    static final String errorMsgFailedToCreateLoadRequest = "[UnityAds] Failed to create load request";

    public BaseLoadModule(SDKMetricsSender sdkMetrics) {
        super(sdkMetrics);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, final LoadOperationState state) {
        JSONObject parameters;
        if (TextUtils.isEmpty((CharSequence)state.placementId)) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INVALID_ARGUMENT, errorMsgPlacementIdNull, true);
            return;
        }
        LoadOperation loadOperation = new LoadOperation(state, new WebViewBridgeInvocation(this._executorService, webViewBridgeInvoker, new IWebViewBridgeInvocationCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(String message, CallbackStatus callbackStatus) {
                BaseLoadModule.this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(AdOperationError.callback_error, (Long)state.duration(), state.isBanner(), state.isHeaderBidding()));
                BaseLoadModule.this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, BaseLoadModule.errorMsgInternalCommunicationFailure, false);
                BaseLoadModule.this.remove(state.getId());
            }

            @Override
            public void onTimeout() {
                BaseLoadModule.this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(AdOperationError.callback_timeout, (Long)state.duration(), state.isBanner(), state.isHeaderBidding()));
                BaseLoadModule.this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, BaseLoadModule.errorMsgInternalCommunicationTimeout, false);
                BaseLoadModule.this.remove(state.getId());
            }
        }));
        try {
            parameters = this.buildBaseParameters(state, loadOperation);
        }
        catch (NullPointerException | JSONException e) {
            this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INTERNAL_ERROR, errorMsgFailedToCreateLoadRequest, true);
            return;
        }
        this.set(loadOperation);
        loadOperation.invoke(state.configuration.getWebViewBridgeTimeout(), parameters);
    }

    JSONObject buildBaseParameters(LoadOperationState state, LoadOperation loadOperation) throws JSONException {
        JSONObject parameters = new JSONObject();
        JSONObject options = this.buildBaseOptions(state);
        options.put("headerBiddingOptions", (Object)state.loadOptions.getData());
        parameters.put("options", (Object)options);
        parameters.put("listenerId", (Object)loadOperation.getId());
        parameters.put("placementId", (Object)state.placementId);
        parameters.put("time", Device.getElapsedRealtime());
        this.addOptionalParameters(state, parameters);
        return parameters;
    }

    JSONObject buildBaseOptions(LoadOperationState state) throws JSONException {
        JSONObject options = new JSONObject();
        options.put("headerBiddingOptions", (Object)state.loadOptions.getData());
        return options;
    }

    abstract void addOptionalParameters(LoadOperationState var1, JSONObject var2) throws JSONException;

    @Override
    public void onUnityAdsAdLoaded(String operationId) {
        ILoadOperation loadOperation = (ILoadOperation)this.get(operationId);
        if (loadOperation == null || loadOperation.getLoadOperationState() == null) {
            return;
        }
        LoadOperationState state = loadOperation.getLoadOperationState();
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadSuccess(state.duration(), state.isBanner(), state.isHeaderBidding()));
        loadOperation.onUnityAdsAdLoaded(state.placementId);
        this.remove(operationId);
    }

    @Override
    public void onUnityAdsFailedToLoad(String operationId, UnityAds.UnityAdsLoadError error2, String message) {
        ILoadOperation loadOperation = (ILoadOperation)this.get(operationId);
        if (loadOperation == null || loadOperation.getLoadOperationState() == null) {
            return;
        }
        LoadOperationState state = loadOperation.getLoadOperationState();
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(error2, (Long)state.duration(), state.isBanner(), state.isHeaderBidding()));
        loadOperation.onUnityAdsFailedToLoad(state.placementId, error2, message);
        this.remove(operationId);
    }

    private void sendOnUnityAdsFailedToLoad(final LoadOperationState state, final UnityAds.UnityAdsLoadError error2, final String message, boolean sendMetrics2) {
        if (state == null || state.listener == null) {
            return;
        }
        if (sendMetrics2) {
            this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdLoadFailure(error2, (Long)state.duration(), state.isBanner(), state.isHeaderBidding()));
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                state.onUnityAdsFailedToLoad(error2, message);
            }
        });
    }
}

