package com.unity3d.services.store.gpbl.bridges.billingclient.common;

import com.unity3d.services.core.reflection.GenericBridge;
import com.unity3d.services.store.gpbl.bridges.billingclient.IBillingClientBuilderBridge;
import com.unity3d.services.store.gpbl.proxies.PurchaseUpdatedListenerProxy;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public abstract class BillingClientBuilderBridgeCommon extends GenericBridge implements IBillingClientBuilderBridge {
	private static final String setListenerMethodName = "setListener";
	protected static final String buildMethodName = "build";

	protected Object _billingClientBuilderInternalInstance;

	public BillingClientBuilderBridgeCommon(Object billingClientBuilderInternalInstance, Map<String, Class<?>[]> functionAndParameters) throws ClassNotFoundException {
		super(appendFunctionAnParameters(functionAndParameters));
		_billingClientBuilderInternalInstance = billingClientBuilderInternalInstance;
	}

	private static Map<String, Class<?>[]> appendFunctionAnParameters(Map<String, Class<?>[]> functionAndParameters) throws ClassNotFoundException {
		functionAndParameters.putAll(new HashMap<String, Class<?>[]>() {{
			put(setListenerMethodName, new Class[]{PurchaseUpdatedListenerProxy.getProxyListenerClass()});
			put(buildMethodName, new Class[]{});
		}});
		return functionAndParameters;
	}

	@Override
	protected String getClassName() {
		return "com.android.billingclient.api.BillingClient$Builder";
	}

	@Override
	public IBillingClientBuilderBridge setListener(PurchaseUpdatedListenerProxy purchaseUpdatedListenerProxy) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
		_billingClientBuilderInternalInstance = callNonVoidMethod(setListenerMethodName, _billingClientBuilderInternalInstance, purchaseUpdatedListenerProxy.getProxyInstance());
		return this;
	}


}
