package com.unity3d.ads.beta

internal class BannerLoadOptions(
   val placementId: String,
   val bannerSize: Pair<Int, Int>,
   val adMarkup: String? = null,
   val extras: Map<String, String>? = null,
   val listener: BannerShowListener? = null,
) {
    class Builder(private val placementId: String, private val bannerSize: Pair<Int, Int>) {
        private var adMarkup: String? = null
        private var extras: Map<String, String>? = null
        private var listener: BannerShowListener? = null

        fun withAdMarkup(adMarkup: String): Builder {
            this.adMarkup = adMarkup
            return this
        }

        fun withExtras(extras: Map<String, String>): Builder {
            this.extras = extras
            return this
        }

        fun withListener(listener: BannerShowListener): Builder {
            this.listener = listener
            return this
        }

        fun build(): BannerLoadOptions {
            return BannerLoadOptions(placementId, bannerSize, adMarkup, extras, listener)
        }
    }
}
