package com.unity3d.services.core.fid

import android.content.Context
import com.unity3d.services.core.reflection.GenericBridge

class FIdStaticBridge: GenericBridge(mapOf(
    Pair(Constants.GET_INSTANCE, arrayOf<Class<*>>(Context::class.java))
), false) {
    fun getInstance(context: Context): FIdBridge? {
        return callNonVoidMethod<Any>(Constants.GET_INSTANCE, null, context)?.let { FIdBridge(it) }
    }

    override fun getClassName(): String {
        return Constants.getClassName()
    }
}