package com.unity3d.ads.core.domain

import com.google.protobuf.kotlin.toByteStringUtf8
import com.unity3d.ads.core.configuration.MediationInitBlobMetadataReader
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.LegacyUserConsentRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.core.device.StorageManager
import gatewayprotocol.v1.InitializationRequestOuterClass.InitializationRequest
import gatewayprotocol.v1.initializationDeviceInfo
import gatewayprotocol.v1.initializationRequest

internal class AndroidGetInitializationRequestPayload(
    private val getClientInfo: GetClientInfo,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val legacyUserConsentRepository: LegacyUserConsentRepository,
    private val mediationInitBlobMetadataReader: MediationInitBlobMetadataReader
) : GetInitializationRequestPayload {
    override suspend fun invoke(): InitializationRequest = initializationRequest {
        isFirstInit = !StorageManager.getStorage(StorageManager.StorageType.PRIVATE).run {
            readStorage() && get("configuration.hasInitialized") as? Boolean ?: false
        }
        clientInfo = getClientInfo()
        idfi = deviceInfoRepository.getIdfi()
        deviceInfoRepository.analyticsUserId?.let { analyticsUserId = it }
        sessionId = sessionRepository.sessionId
        deviceInfo = initializationDeviceInfo {
            bundleId = deviceInfoRepository.appName
            deviceModel = deviceInfoRepository.model
            deviceMake = deviceInfoRepository.manufacturer
            osVersion = deviceInfoRepository.osVersion
            totalDiskSpace = deviceInfoRepository.staticDeviceInfo().totalDiskSpace
            totalRamMemory = deviceInfoRepository.staticDeviceInfo().totalRamMemory
            currentUiTheme = deviceInfoRepository.currentUiTheme.toLong()
            networkOperator = deviceInfoRepository.dynamicDeviceInfo.networkOperator
            batteryLevel = deviceInfoRepository.dynamicDeviceInfo.batteryLevel
            batteryStatus = deviceInfoRepository.dynamicDeviceInfo.batteryStatus
            systemBootTime = deviceInfoRepository.systemBootTime
            language = deviceInfoRepository.dynamicDeviceInfo.language
            localList = deviceInfoRepository.localeList.joinToString(",")
            connectionType = deviceInfoRepository.connectionTypeStr
        }

        val auidByteString = deviceInfoRepository.getAuidByteString()
        if (auidByteString != null) {
            this.auid = auidByteString
        }

        val auidString = deviceInfoRepository.getAuidString()
        if (!auidString.isNullOrEmpty()) {
            this.auidString = auidString
        }

        val privacy = sessionRepository.getPrivacy()
        if (!privacy.isEmpty) {
            this.privacy = privacy
        }

        val gatewayCache = sessionRepository.getGatewayCache()
        if (!gatewayCache.isEmpty) {
            cache = gatewayCache
        }

        mediationInitBlobMetadataReader.read<String?>()?.let {
            uadsInitBlob = it.toByteStringUtf8()
        }
        legacyUserConsentRepository.legacyFlowUserConsent?.let { legacyFlowUserConsent = it }
    }
}