/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.proxies;

import com.unity3d.services.core.reflection.GenericListenerProxy;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge;
import com.unity3d.services.store.gpbl.listeners.PurchaseUpdatedResponseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PurchaseUpdatedListenerProxy
extends GenericListenerProxy {
    private static final String onPurchasesUpdatedMethodName = "onPurchasesUpdated";
    private PurchaseUpdatedResponseListener purchaseUpdatedResponseListener;

    public PurchaseUpdatedListenerProxy(PurchaseUpdatedResponseListener purchaseUpdatedResponseListener) {
        this.purchaseUpdatedResponseListener = purchaseUpdatedResponseListener;
    }

    @Override
    public Class<?> getProxyClass() throws ClassNotFoundException {
        return PurchaseUpdatedListenerProxy.getProxyListenerClass();
    }

    public static Class<?> getProxyListenerClass() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.PurchasesUpdatedListener");
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result2 = null;
        if (m.getName().equals(onPurchasesUpdatedMethodName)) {
            this.onPurchasesUpdated(args[0], (List)args[1]);
        } else {
            result2 = super.invoke(proxy, m, args);
        }
        return result2;
    }

    public void onPurchasesUpdated(Object billingResult, List<Object> purchases) {
        ArrayList<PurchaseBridge> purchasesBridge = null;
        if (purchases != null) {
            purchasesBridge = new ArrayList<PurchaseBridge>();
            for (Object purchase : purchases) {
                purchasesBridge.add(new PurchaseBridge(purchase));
            }
        }
        if (this.purchaseUpdatedResponseListener != null) {
            this.purchaseUpdatedResponseListener.onPurchaseUpdated(new BillingResultBridge(billingResult), purchasesBridge);
        }
    }
}

