package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.FullScreenWebViewDisplay

enum class AdActivity(val activityName: String) {
    GOOGLE_ADS_ACTIVITY("com.google.android.gms.ads.AdActivity"),
    FACEBOOK_ADS_ACTIVITY("com.facebook.ads.AudienceNetworkActivity"),
    APPLOVIN_ADS_ACTIVITY("com.applovin.adview.AppLovinFullscreenThemedActivity"),
    APPLOVIN_INTERSTITIAL_ACTIVITY("com.applovin.adview.AppLovinFullscreenActivity"),
    APPLOVIN_INTERSTITIAL_ORIENTATION_AWARE_ACTIVITY("com.applovin.impl.adview.AppLovinOrientationAwareInterstitialActivity"),
    IRONSOURCE_ADS_ACTIVITY("com.ironsource.sdk.controller.ControllerActivity"),
    IRONSOURCE_INTERSTITIAL_ACTIVITY("com.ironsource.sdk.controller.InterstitialActivity"),
    UNITY_ADS_FULLSCREEN_ACTIVITY(FullScreenWebViewDisplay::class.qualifiedName ?: "FullScreenWebViewDisplay");
}

class AndroidGetIsAdActivity {
    operator fun invoke(activityName: String): Boolean = activityName in knownAdActivities

    companion object {
        private val knownAdActivities = AdActivity.values().map(AdActivity::activityName).toSet()
    }
}