package com.unity3d.ads.network.model

/**
 * Data class representing a generic http request
 */

data class HttpRequest @JvmOverloads constructor(
        val baseURL: String,
        val path: String = "",
        val method: RequestType = RequestType.GET,
        val body: HttpBody = HttpBody.EmptyBody,
        val headers: Map<String, List<String>> = emptyMap(),
        val parameters: Map<String, String> = emptyMap(),
        val scheme: String = DEFAULT_SCHEME,
        val port: Int? = null,
        val connectTimeout: Int = DEFAULT_TIMEOUT,
        val readTimeout: Int = DEFAULT_TIMEOUT,
        val writeTimeout: Int = DEFAULT_TIMEOUT,
        val callTimeout: Int = DEFAULT_TIMEOUT,
) {
    companion object {
        private const val DEFAULT_TIMEOUT: Int = 30_000 // seconds
        private const val DEFAULT_SCHEME: String = "https"
    }
}
