package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.manager.OfferwallManager
import com.unity3d.ads.core.data.manager.OmidManager
import com.unity3d.ads.core.data.manager.ScarManager
import com.unity3d.ads.core.data.repository.MediationRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.UnityAdsConstants
import com.unity3d.services.core.properties.MadeWithUnityDetector
import gatewayprotocol.v1.ClientInfoOuterClass
import gatewayprotocol.v1.ClientInfoOuterClass.ClientInfo
import gatewayprotocol.v1.ClientInfoOuterClass.Platform
import gatewayprotocol.v1.clientInfo

internal class AndroidGetClientInfo(
    private val sessionRepository: SessionRepository,
    private val mediationRepository: MediationRepository,
    private val omidManager: OmidManager,
    private val scarManager: ScarManager,
    private val offerwallManager: OfferwallManager,
) : GetClientInfo {
    override suspend fun invoke(): ClientInfo {
        return clientInfo {
            sdkVersion = UnityAdsConstants.ClientInfo.SDK_VERSION
            sdkVersionName = UnityAdsConstants.ClientInfo.SDK_VERSION_NAME
            sessionRepository.gameId?.let { gameId = it }
            test = sessionRepository.isTestModeEnabled
            platform = Platform.PLATFORM_ANDROID
            mediationProvider = mediationRepository.mediationProvider()
            mediationRepository.name?.let {
                if (mediationProvider == ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_CUSTOM) {
                    customMediationName = it
                }
            }
            mediationRepository.version?.let {
                mediationVersion = it
            }
            scarManager.getVersion()?.let {
                scarVersionName = it
            }
            offerwallManager.getVersion()?.let {
                offerwallVersion = it
            }
            omidVersion = omidManager.version
            omidPartnerVersion = UnityAdsConstants.OpenMeasurement.OM_PARTNER_VERSION
            sdkDevelopmentPlatform = if (MadeWithUnityDetector.isMadeWithUnity()) "Unity" else ""
        }
    }
}
