/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.log;

import android.util.Log;
import com.unity3d.services.core.log.DeviceLogEntry;
import com.unity3d.services.core.log.DeviceLogLevel;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;

public class DeviceLog {
    private static boolean LOG_ERROR;
    private static boolean LOG_WARNING;
    private static boolean LOG_INFO;
    private static boolean LOG_DEBUG;
    private static boolean FORCE_DEBUG_LOG;
    private static final int MAX_DEBUG_MSG_LENGTH = 3072;
    private static final int LOGLEVEL_ERROR = 1;
    private static final int LOGLEVEL_WARNING = 2;
    public static final int LOGLEVEL_INFO = 4;
    public static final int LOGLEVEL_DEBUG = 8;
    private static final HashMap<UnityAdsLogLevel, DeviceLogLevel> _deviceLogLevel;

    public static void setLogLevel(int newLevel) {
        if (newLevel >= 8) {
            LOG_ERROR = true;
            LOG_WARNING = true;
            LOG_INFO = true;
            LOG_DEBUG = true;
        } else if (newLevel >= 4) {
            LOG_ERROR = true;
            LOG_WARNING = true;
            LOG_INFO = true;
            LOG_DEBUG = false;
        } else if (newLevel >= 2) {
            LOG_ERROR = true;
            LOG_WARNING = true;
            LOG_INFO = false;
            LOG_DEBUG = false;
        } else if (newLevel >= 1) {
            LOG_ERROR = true;
            LOG_WARNING = false;
            LOG_INFO = false;
            LOG_DEBUG = false;
        } else {
            LOG_ERROR = false;
            LOG_WARNING = false;
            LOG_INFO = false;
            LOG_DEBUG = false;
        }
    }

    public static void entered() {
        DeviceLog.debug("ENTERED METHOD");
    }

    public static void info(String message) {
        DeviceLog.write(UnityAdsLogLevel.INFO, DeviceLog.checkMessage(message));
    }

    public static void info(String format, Object ... args) {
        DeviceLog.info(String.format(format, args));
    }

    public static void debug(String message) {
        if (!DeviceLog.isDebugEnabled()) {
            return;
        }
        if (message.length() > 3072) {
            DeviceLog.debug(message.substring(0, 3072));
            if (message.length() < 30720) {
                DeviceLog.debug(message.substring(3072));
            }
            return;
        }
        DeviceLog.write(UnityAdsLogLevel.DEBUG, DeviceLog.checkMessage(message));
    }

    public static void debug(String format, Object ... args) {
        if (!DeviceLog.isDebugEnabled()) {
            return;
        }
        DeviceLog.debug(String.format(format, args));
    }

    private static boolean isDebugEnabled() {
        return LOG_DEBUG || FORCE_DEBUG_LOG;
    }

    public static void warning(String message) {
        DeviceLog.write(UnityAdsLogLevel.WARNING, DeviceLog.checkMessage(message));
    }

    public static void warning(String format, Object ... args) {
        DeviceLog.warning(String.format(format, args));
    }

    public static void error(String message) {
        DeviceLog.write(UnityAdsLogLevel.ERROR, DeviceLog.checkMessage(message));
    }

    public static void exception(String message, Exception exception) {
        String finalMessage = "";
        if (message != null) {
            finalMessage = finalMessage + message;
        }
        if (exception != null) {
            finalMessage = finalMessage + ": " + exception.getMessage();
        }
        if (exception != null && exception.getCause() != null) {
            finalMessage = finalMessage + ": " + exception.getCause().getMessage();
        }
        DeviceLog.write(UnityAdsLogLevel.ERROR, finalMessage);
    }

    public static void error(String format, Object ... args) {
        DeviceLog.error(String.format(format, args));
    }

    private static void write(UnityAdsLogLevel level, String message) {
        boolean logThisMessage = true;
        switch (level) {
            case INFO: {
                logThisMessage = LOG_INFO;
                break;
            }
            case DEBUG: {
                logThisMessage = LOG_DEBUG;
                break;
            }
            case WARNING: {
                logThisMessage = LOG_WARNING;
                break;
            }
            case ERROR: {
                logThisMessage = LOG_ERROR;
                break;
            }
        }
        if (FORCE_DEBUG_LOG) {
            logThisMessage = true;
        }
        if (logThisMessage) {
            DeviceLogEntry logEntry = DeviceLog.createLogEntry(level, message);
            DeviceLog.writeToLog(logEntry);
        }
    }

    private static String checkMessage(String message) {
        String finalMessage = message == null || message.length() == 0 ? "DO NOT USE EMPTY MESSAGES, use DeviceLog.entered() instead" : message;
        return finalMessage;
    }

    private static DeviceLogLevel getLogLevel(UnityAdsLogLevel logLevel) {
        return _deviceLogLevel.get((Object)logLevel);
    }

    private static DeviceLogEntry createLogEntry(UnityAdsLogLevel level, String message) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        DeviceLogLevel logLevel = DeviceLog.getLogLevel(level);
        DeviceLogEntry logEntry = null;
        if (logLevel != null) {
            StackTraceElement e;
            int callerIndex;
            boolean markedIndex = false;
            for (callerIndex = 0; callerIndex < stack.length; ++callerIndex) {
                e = stack[callerIndex];
                if (e.getClassName().equals(DeviceLog.class.getName())) {
                    markedIndex = true;
                }
                if (!e.getClassName().equals(DeviceLog.class.getName()) && markedIndex) break;
            }
            e = null;
            if (callerIndex < stack.length) {
                e = stack[callerIndex];
            }
            if (e != null) {
                logEntry = new DeviceLogEntry(logLevel, message, e);
            }
        }
        return logEntry;
    }

    private static void writeToLog(DeviceLogEntry logEntry) {
        Method receivingMethod = null;
        if (logEntry != null && logEntry.getLogLevel() != null) {
            try {
                receivingMethod = Log.class.getMethod(logEntry.getLogLevel().getReceivingMethodName(), String.class, String.class);
            }
            catch (Exception e) {
                Log.e((String)"UnityAds", (String)"Writing to log failed!", (Throwable)e);
            }
            if (receivingMethod != null) {
                try {
                    receivingMethod.invoke(null, logEntry.getLogLevel().getLogTag(), logEntry.getParsedMessage());
                }
                catch (Exception e) {
                    Log.e((String)"UnityAds", (String)"Writing to log failed!", (Throwable)e);
                }
            }
        }
    }

    static {
        File forceDebugMode;
        LOG_ERROR = true;
        LOG_WARNING = true;
        LOG_INFO = true;
        LOG_DEBUG = true;
        FORCE_DEBUG_LOG = false;
        _deviceLogLevel = new HashMap();
        if (_deviceLogLevel.size() == 0) {
            _deviceLogLevel.put(UnityAdsLogLevel.INFO, new DeviceLogLevel("i"));
            _deviceLogLevel.put(UnityAdsLogLevel.DEBUG, new DeviceLogLevel("d"));
            _deviceLogLevel.put(UnityAdsLogLevel.WARNING, new DeviceLogLevel("w"));
            _deviceLogLevel.put(UnityAdsLogLevel.ERROR, new DeviceLogLevel("e"));
        }
        if ((forceDebugMode = new File("/data/local/tmp/UnityAdsForceDebugMode")).exists()) {
            FORCE_DEBUG_LOG = true;
        }
    }

    public static enum UnityAdsLogLevel {
        INFO,
        DEBUG,
        WARNING,
        ERROR;

    }
}

