package com.unity3d.ads.core.domain

import gatewayprotocol.v1.UniversalRequestKt.payload
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest

internal class GetAndroidInitializationRequest(
    private val getInitializationRequestPayload: GetInitializationRequestPayload,
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
) : GetInitializationRequest {
    override suspend fun invoke(): UniversalRequest {
        val request = getInitializationRequestPayload()
        val initPayload = payload {
            initializationRequest = request
        }
        return getUniversalRequestForPayLoad(initPayload)
    }
}
