package com.unity3d.ads.core.extensions

import android.webkit.WebViewClient
import com.unity3d.ads.adplayer.model.ErrorReason

fun Int.webResourceToErrorReason(): ErrorReason {
    return when (this) {
        WebViewClient.ERROR_UNKNOWN -> ErrorReason.REASON_WEB_ERROR_UNKNOWN
        WebViewClient.ERROR_HOST_LOOKUP -> ErrorReason.REASON_WEB_ERROR_HOST_LOOKUP
        WebViewClient.ERROR_UNSUPPORTED_AUTH_SCHEME -> ErrorReason.REASON_WEB_ERROR_UNSUPPORTED_AUTH_SCHEME
        WebViewClient.ERROR_AUTHENTICATION -> ErrorReason.REASON_WEB_ERROR_AUTHENTICATION
        WebViewClient.ERROR_PROXY_AUTHENTICATION -> ErrorReason.REASON_WEB_ERROR_PROXY_AUTHENTICATION
        WebViewClient.ERROR_CONNECT -> ErrorReason.REASON_WEB_ERROR_CONNECT
        WebViewClient.ERROR_IO -> ErrorReason.REASON_WEB_ERROR_IO
        WebViewClient.ERROR_TIMEOUT -> ErrorReason.REASON_WEB_ERROR_TIMEOUT
        WebViewClient.ERROR_REDIRECT_LOOP -> ErrorReason.REASON_WEB_ERROR_REDIRECT_LOOP
        WebViewClient.ERROR_UNSUPPORTED_SCHEME -> ErrorReason.REASON_WEB_ERROR_UNSUPPORTED_SCHEME
        WebViewClient.ERROR_FAILED_SSL_HANDSHAKE -> ErrorReason.REASON_WEB_ERROR_FAILED_SSL_HANDSHAKE
        WebViewClient.ERROR_BAD_URL -> ErrorReason.REASON_WEB_ERROR_BAD_URL
        WebViewClient.ERROR_FILE -> ErrorReason.REASON_WEB_ERROR_FILE
        WebViewClient.ERROR_FILE_NOT_FOUND -> ErrorReason.REASON_WEB_ERROR_FILE_NOT_FOUND
        WebViewClient.ERROR_TOO_MANY_REQUESTS -> ErrorReason.REASON_WEB_ERROR_TOO_MANY_REQUESTS
        WebViewClient.ERROR_UNSAFE_RESOURCE -> ErrorReason.REASON_WEB_ERROR_UNSAFE_RESOURCE
        else -> ErrorReason.REASON_UNKNOWN
    }
}