package com.unity3d.ads.core.domain

import android.os.SystemClock
import com.unity3d.ads.core.extensions.fromMillis
import com.unity3d.services.core.properties.SdkProperties
import gatewayprotocol.v1.TimestampsOuterClass.Timestamps
import gatewayprotocol.v1.timestamps



class GetAndroidSharedDataTimestamps : GetSharedDataTimestamps {
    override fun invoke(): Timestamps {
        return timestamps {
           // Current UTC timestamp in milliseconds
           timestamp = fromMillis(System.currentTimeMillis())
           // Milliseconds since SDK was initialized using monotonic timer
           sessionTimestamp = SystemClock.elapsedRealtime() - SdkProperties.getInitializationTime()
       }
    }
}