/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.adapters;

import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.IAdsErrorHandler;
import com.unity3d.scar.adapter.common.IScarAdapter;
import com.unity3d.scar.adapter.common.IUnityAdsError;
import com.unity3d.scar.adapter.common.WebViewAdsError;
import com.unity3d.scar.adapter.v2000.ScarAdapter;
import com.unity3d.services.ads.gmascar.finder.ScarAdapterVersion;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;

public class ScarAdapterFactory {
    public IScarAdapter createScarAdapter(ScarAdapterVersion adapterVersion, IAdsErrorHandler<WebViewAdsError> adsErrorHandler) {
        ScarAdapter scarAdapter = null;
        switch (adapterVersion) {
            case V20: {
                scarAdapter = new ScarAdapter(adsErrorHandler);
                break;
            }
            case V21: {
                scarAdapter = new com.unity3d.scar.adapter.v2100.ScarAdapter(adsErrorHandler, SdkProperties.getVersionName());
                break;
            }
            case V23: {
                scarAdapter = new com.unity3d.scar.adapter.v2300.ScarAdapter(adsErrorHandler, SdkProperties.getVersionName());
                break;
            }
            default: {
                this.reportAdapterFailure(adapterVersion, adsErrorHandler);
            }
        }
        return scarAdapter;
    }

    private void reportAdapterFailure(ScarAdapterVersion adapterVersion, IAdsErrorHandler<WebViewAdsError> adsErrorHandler) {
        String errorMessage = String.format("SCAR version %s is not supported.", adapterVersion.name());
        adsErrorHandler.handleError((IUnityAdsError)GMAAdsError.AdapterCreationError((String)errorMessage));
        DeviceLog.debug(errorMessage);
    }
}

