package com.unity3d.ads.core.data.model.exception

import com.unity3d.ads.core.domain.InitializeAndroidBoldSDK.Companion.MSG_NETWORK
import com.unity3d.ads.core.domain.InitializeAndroidBoldSDK.Companion.MSG_TIMEOUT
import com.unity3d.ads.core.domain.InitializeAndroidBoldSDK.Companion.MSG_UNKNOWN
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_GATEWAY
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_NETWORK
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_TIMEOUT
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_UNKNOWN
import kotlinx.coroutines.TimeoutCancellationException

data class InitializationException(
    override val message: String,
    val throwable: Throwable? = null,
    val reason: String = REASON_GATEWAY,
    val reasonDebug: String? = null
) : Exception(message) {
    companion object {
        fun parseFrom(e: Exception): InitializationException {
            return when (e) {
                is TimeoutCancellationException -> InitializationException(
                    message = MSG_TIMEOUT,
                    throwable = e,
                    reason = REASON_TIMEOUT,
                    reasonDebug = e.message
                )
                is UnityAdsNetworkException -> InitializationException(
                    message = MSG_NETWORK,
                    throwable = e,
                    reason = "$REASON_NETWORK.${e.code}",
                    reasonDebug = e.message
                )
                is InitializationException -> e
                else -> InitializationException(
                    message = MSG_UNKNOWN,
                    throwable = e,
                    reason = REASON_UNKNOWN,
                    reasonDebug = e.message
                )
            }
        }
    }
}