package com.unity3d.ads.core.data.datasource

import com.unity3d.ads.core.data.model.CacheError
import com.unity3d.ads.core.data.model.CacheResult
import com.unity3d.ads.core.data.model.CacheSource
import org.koin.core.annotation.Single
import com.unity3d.ads.core.data.model.CachedFile
import com.unity3d.services.core.di.ServiceProvider
import com.unity3d.services.core.di.ServiceProvider.NAMED_LOCAL
import org.koin.core.annotation.Named
import java.io.File

@Single
@Named(NAMED_LOCAL)
class AndroidLocalCacheDataSource : CacheDataSource {
    override suspend fun getFile(
        cachePath: File,
        fileName: String,
        url: String?,
        priority: Int?
    ): CacheResult {
        val file = File(cachePath, fileName)
        return if (file.exists()) {
            val result = CachedFile(
                objectId = "",
                url = url ?: "",
                name = fileName,
                file = file,
            )
            CacheResult.Success(result, CacheSource.LOCAL)
        } else {
            CacheResult.Failure(CacheError.FILE_NOT_FOUND, CacheSource.LOCAL)
        }
    }
}