package com.unity3d.ads.core.domain

import android.annotation.SuppressLint
import android.content.Context
import android.graphics.Color
import android.os.Build
import android.webkit.WebSettings
import android.webkit.WebView
import com.unity3d.ads.adplayer.AndroidWebViewClient
import com.unity3d.ads.adplayer.AndroidWebViewContainer
import com.unity3d.services.core.di.ServiceProvider.DEFAULT_DISPATCHER
import com.unity3d.services.core.di.ServiceProvider.MAIN_DISPATCHER
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.withContext
import org.koin.core.annotation.Factory
import org.koin.core.annotation.Named

@Factory
class AndroidGetWebViewContainerUseCase(
    private val context: Context,
    private val androidWebViewClient: AndroidWebViewClient,
    private val sendWebViewClientErrorDiagnostics: SendWebViewClientErrorDiagnostics,
    @Named(MAIN_DISPATCHER) private val mainDispatcher: CoroutineDispatcher,
    @Named(DEFAULT_DISPATCHER) private val defaultDispatcher: CoroutineDispatcher,
) : GetWebViewContainerUseCase {
    @SuppressLint("SetJavaScriptEnabled")
    override suspend fun invoke(adPlayerScope: CoroutineScope): AndroidWebViewContainer {
        val webview = withContext(mainDispatcher) {
            WebView(context).apply {
                settings.apply {
                    allowFileAccess = false
                    blockNetworkImage = false
                    blockNetworkLoads = false
                    builtInZoomControls = false
                    cacheMode = WebSettings.LOAD_DEFAULT
                    databaseEnabled = false
                    displayZoomControls = false
                    domStorageEnabled = false
                    setGeolocationEnabled(false)
                    javaScriptCanOpenWindowsAutomatically = false
                    javaScriptEnabled = true
                    loadWithOverviewMode = false
                    loadsImagesAutomatically = true
                    mediaPlaybackRequiresUserGesture = false
                    if (Build.VERSION.SDK_INT >= 21) {
                        mixedContentMode = WebSettings.MIXED_CONTENT_NEVER_ALLOW
                    }
                    setNeedInitialFocus(true)
                    setSupportMultipleWindows(false)
                    setSupportZoom(false)
                    useWideViewPort = true
                    mediaPlaybackRequiresUserGesture = false
                }

                webViewClient = androidWebViewClient

                isHorizontalScrollBarEnabled = false
                isVerticalScrollBarEnabled = false
                setInitialScale(0)
                setBackgroundColor(Color.TRANSPARENT)
                setBackgroundResource(0)
            }
        }

        return AndroidWebViewContainer(
            webview,
            androidWebViewClient,
            sendWebViewClientErrorDiagnostics,
            mainDispatcher,
            defaultDispatcher,
            adPlayerScope,
        )
    }
}