package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.datasource.ByteStringDataSource
import com.unity3d.ads.core.extensions.fromBase64
import com.unity3d.services.core.configuration.ExperimentsBase.EXP_TAG_IS_BOLD_NEXT_SESSION
import com.unity3d.services.core.di.ServiceProvider.DATA_STORE_GATEWAY_CACHE
import com.unity3d.services.core.di.ServiceProvider.IO_DISPATCHER
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import org.json.JSONObject
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
class AndroidBoldExperimentHandler (
    @Named(DATA_STORE_GATEWAY_CACHE) private val gatewayCacheDataSource: ByteStringDataSource,
    @Named(IO_DISPATCHER) private val ioDispatcher: CoroutineDispatcher
): BoldExperimentHandler {
    override fun invoke(configData: String) {
        // Check if we received the boldSdkNextSessionEnabled flag so we can parse the version
        val jsonConfig = JSONObject(configData)
        val experiments = jsonConfig.opt(EXPO_NODE_NAME) as? JSONObject
        val boldSdkExperiment = experiments?.opt(EXP_TAG_IS_BOLD_NEXT_SESSION) as? JSONObject
        val base64EncodedVersion = boldSdkExperiment?.opt(BOLD_VERSION) as? String
        base64EncodedVersion?.let {
            CoroutineScope(ioDispatcher).launch {
                gatewayCacheDataSource.set(it.fromBase64())
            }
        }
    }

    companion object {
        const val EXPO_NODE_NAME = "expo"
        const val BOLD_VERSION = "version"
    }

}