/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store;

import android.app.Application;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.core.StoreEventListenerFactory;
import com.unity3d.services.store.core.StoreExceptionHandler;
import com.unity3d.services.store.core.StoreLifecycleListener;
import com.unity3d.services.store.gpbl.StoreBilling;
import com.unity3d.services.store.gpbl.listeners.StoreEventListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J*\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u001aJ\u0006\u0010\u001b\u001a\u00020\u0011J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001e\u0010\u001d\u001a\u00020\u00112\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u001fj\b\u0012\u0004\u0012\u00020\u0015` J\u0006\u0010!\u001a\u00020\u0011R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unity3d/services/store/StoreMonitor;", "", "storeEventListenerFactory", "Lcom/unity3d/services/store/core/StoreEventListenerFactory;", "storeExceptionHandler", "Lcom/unity3d/services/store/core/StoreExceptionHandler;", "(Lcom/unity3d/services/store/core/StoreEventListenerFactory;Lcom/unity3d/services/store/core/StoreExceptionHandler;)V", "_isInitialized", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "isInitialized", "()Z", "storeBilling", "Lcom/unity3d/services/store/gpbl/StoreBilling;", "storeLifecycleListener", "Lcom/unity3d/services/store/core/StoreLifecycleListener;", "getPurchaseHistory", "", "operationId", "", "purchaseType", "", "maxPurchases", "getPurchases", "getSkuDetails", "skuList", "", "initialize", "isFeatureSupported", "startPurchaseTracking", "purchaseTypes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "stopPurchaseTracking", "unity-ads_release"})
public final class StoreMonitor {
    @NotNull
    private final StoreEventListenerFactory storeEventListenerFactory;
    @NotNull
    private final StoreExceptionHandler storeExceptionHandler;
    @Nullable
    private StoreBilling storeBilling;
    @Nullable
    private StoreLifecycleListener storeLifecycleListener;
    @NotNull
    private final MutableStateFlow<Boolean> _isInitialized;

    public StoreMonitor(@NotNull StoreEventListenerFactory storeEventListenerFactory, @NotNull StoreExceptionHandler storeExceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)storeEventListenerFactory, (String)"storeEventListenerFactory");
        Intrinsics.checkNotNullParameter((Object)storeExceptionHandler, (String)"storeExceptionHandler");
        this.storeEventListenerFactory = storeEventListenerFactory;
        this.storeExceptionHandler = storeExceptionHandler;
        this._isInitialized = StateFlowKt.MutableStateFlow((Object)false);
    }

    public final boolean isInitialized() {
        return (Boolean)this._isInitialized.getValue();
    }

    public final void initialize() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        StoreEventListener storeEventListener = StoreEventListenerFactory.invoke$default(this.storeEventListenerFactory, 0, false, 3, null);
        if (this.isInitialized()) {
            storeEventListener.triggerIsAlreadyInitialized();
            return;
        }
        StoreBilling storeBilling = this.storeBilling = new StoreBilling(ClientProperties.getApplicationContext(), storeEventListener);
        if (storeBilling != null) {
            storeBilling.initialize(storeEventListener);
        }
        this._isInitialized.setValue((Object)true);
    }

    public final int isFeatureSupported(int operationId, @Nullable String purchaseType) {
        StoreEventListener storeEventListener = StoreEventListenerFactory.invoke$default(this.storeEventListenerFactory, operationId, false, 2, null);
        int result = -1;
        try {
            StoreBilling storeBilling = this.storeBilling;
            result = storeBilling != null ? storeBilling.isFeatureSupported(purchaseType) : -1;
            storeEventListener.triggerFeatureSupported(result);
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.IS_FEATURE_SUPPORTED_REQUEST_ERROR, operationId, exception);
        }
        return result;
    }

    public final void getPurchases(int operationId, @Nullable String purchaseType) {
        StoreEventListener storeEventListener = StoreEventListenerFactory.invoke$default(this.storeEventListenerFactory, operationId, false, 2, null);
        try {
            if (this.storeBilling == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            StoreBilling storeBilling = this.storeBilling;
            if (storeBilling != null) {
                storeBilling.getPurchases(purchaseType, storeEventListener);
            }
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.PURCHASES_REQUEST_ERROR, operationId, exception);
        }
    }

    public final void getPurchaseHistory(int operationId, @Nullable String purchaseType, int maxPurchases) {
        StoreEventListener storeEventListener = StoreEventListenerFactory.invoke$default(this.storeEventListenerFactory, operationId, false, 2, null);
        try {
            StoreBilling storeBilling = this.storeBilling;
            if (storeBilling != null) {
                storeBilling.getPurchaseHistory(purchaseType, maxPurchases, storeEventListener);
            }
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.PURCHASE_HISTORY_LIST_REQUEST_ERROR, operationId, exception);
        }
    }

    public final void getSkuDetails(int operationId, @Nullable String purchaseType, @Nullable List<String> skuList) {
        StoreEventListener storeEventListener = StoreEventListenerFactory.invoke$default(this.storeEventListenerFactory, operationId, false, 2, null);
        try {
            StoreBilling storeBilling = this.storeBilling;
            if (storeBilling != null) {
                storeBilling.getSkuDetails(purchaseType, skuList, storeEventListener);
            }
        }
        catch (Exception exception) {
            this.storeExceptionHandler.handleStoreException(StoreEvent.SKU_DETAILS_LIST_REQUEST_ERROR, operationId, exception);
        }
    }

    public final void startPurchaseTracking(@NotNull ArrayList<String> purchaseTypes) {
        Intrinsics.checkNotNullParameter(purchaseTypes, (String)"purchaseTypes");
        StoreEventListener storeEventListener = StoreEventListenerFactory.invoke$default(this.storeEventListenerFactory, 0, true, 1, null);
        if (this.storeLifecycleListener != null) {
            this.stopPurchaseTracking();
        }
        StoreBilling storeBilling = this.storeBilling;
        Intrinsics.checkNotNull((Object)storeBilling);
        this.storeLifecycleListener = new StoreLifecycleListener(purchaseTypes, storeBilling, storeEventListener);
        ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.storeLifecycleListener);
    }

    public final void stopPurchaseTracking() {
        if (this.storeLifecycleListener != null) {
            ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.storeLifecycleListener);
            this.storeLifecycleListener = null;
        }
    }
}

