package com.unity3d.ads.core.domain.events

import com.unity3d.ads.core.domain.GetSharedDataTimestamps
import gateway.v1.DiagnosticEventRequestOuterClass.DiagnosticEventType
import gateway.v1.DiagnosticEventRequestOuterClass.DiagnosticEvent
import gateway.v1.diagnosticEvent

internal class GetDiagnosticEventRequest(
    private val getSharedDataTimestamps: GetSharedDataTimestamps
) {
    operator fun invoke(eventName: String, tags: Map<String, String>?, intTags: Map<String, Int>?, value: Double?): DiagnosticEvent {
        return diagnosticEvent {
            eventType = DiagnosticEventType.DIAGNOSTIC_EVENT_TYPE_CUSTOM
            timestamps = getSharedDataTimestamps()
            customEventType = eventName
            tags?.let { stringTags.putAll(it) }
            intTags?.let { this.intTags.putAll(it) }
            value?.let { timeValue = it }
        }
    }
}