package com.unity3d.ads.core.data.datasource

import androidx.datastore.core.DataMigration
import ByteStringStoreOuterClass.ByteStringStore
import com.unity3d.ads.core.extensions.toISO8859ByteString
import com.unity3d.services.core.preferences.AndroidPreferences

class DefaultByteStringMigration(
    private val name: String,
    private val key: String,
    private val getPreferenceString: GetPreferenceString
) : DataMigration<ByteStringStore> {
    override suspend fun cleanUp() {
        // nothing to cleanup
    }

    override suspend fun shouldMigrate(currentData: ByteStringStore): Boolean {
        return currentData.data.isEmpty
    }

    override suspend fun migrate(currentData: ByteStringStore): ByteStringStore {
        val data = getPreferenceString()
        AndroidPreferences.setString(name, key, data) // legacy support
        return ByteStringStore.newBuilder()
            .setData(data.toISO8859ByteString())
            .build()
    }
}