/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.reflection;

import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class GenericBridge {
    private final String _className = this.getClassName();
    private final Map<String, Class[]> _functionAndParameters;
    private final Map<String, Method> _methodMap;
    private boolean _methodMapBuilt = false;

    protected abstract String getClassName();

    public GenericBridge(Map<String, Class[]> functionAndParameters) {
        this._functionAndParameters = functionAndParameters;
        this._methodMap = new HashMap<String, Method>();
        this.buildMethodMap();
    }

    public Map<String, Class[]> getFunctionMap() {
        return this._functionAndParameters;
    }

    public Class classForName() {
        try {
            Class<?> getClass = Class.forName(this._className);
            if (getClass != null) {
                return getClass;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            DeviceLog.debug("ERROR: Could not find Class %s %s", this._className, e.getLocalizedMessage());
            return null;
        }
    }

    public boolean exists() {
        if (this.classForName() == null) {
            DeviceLog.debug("ERROR: Could not find class %s", this._className);
            return false;
        }
        if (!this._methodMapBuilt) {
            this.buildMethodMap();
        }
        return this._methodMap.size() == this.getFunctionMap().size();
    }

    private void buildMethodMap() {
        boolean methodMapNoErrors = true;
        for (Map.Entry<String, Class[]> entry : this.getFunctionMap().entrySet()) {
            Class[] parameterClasses = entry.getValue();
            try {
                Method method = this.getReflectiveMethod(this.classForName(), entry.getKey(), parameterClasses);
                if (method == null) continue;
                this._methodMap.put(entry.getKey(), method);
            }
            catch (Exception e) {
                DeviceLog.debug("ERROR: Could not find %s class with method %s and parameters : %s", this._className, entry.getKey(), parameterClasses);
                methodMapNoErrors = false;
            }
        }
        this._methodMapBuilt = methodMapNoErrors;
    }

    private Method getMethod(String methodName) {
        return this._methodMap.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getReflectiveMethod(Class methodClass, String methodName, Class ... parameterClasses) {
        Method method = null;
        try {
            method = methodClass.getDeclaredMethod(methodName, parameterClasses);
            return method;
        }
        catch (Exception e) {
            DeviceLog.debug("ERROR: Could not find method %s in %s", methodName, methodClass.getName() + " " + e.getLocalizedMessage());
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.GMA, (Enum)GMAEvent.METHOD_ERROR, new Object[0]);
        }
        finally {
            return method;
        }
    }

    public void callVoidMethod(String methodName, Object callingObj, Object ... parameters) {
        Method method = this.getMethod(methodName);
        if (method == null) {
            DeviceLog.debug("ERROR: Could not find method %s", methodName);
            return;
        }
        try {
            method.invoke(callingObj, parameters);
        }
        catch (Exception e) {
            DeviceLog.debug("ERROR: Could not invoke method %s : %s", methodName, e.getLocalizedMessage());
        }
    }

    public <T> T callNonVoidMethod(String methodName, Object callingObj, Object ... parameters) {
        Method method = this.getMethod(methodName);
        if (method == null) {
            DeviceLog.debug("ERROR: Could not find method %s", methodName);
            return null;
        }
        try {
            return (T)method.invoke(callingObj, parameters);
        }
        catch (Exception e) {
            DeviceLog.debug("ERROR: Could not invoke method %s : %s", methodName, e.getLocalizedMessage());
            return null;
        }
    }
}

