/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.device.reader.IDeviceInfoDataCompressor;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import java.util.Map;

public class DeviceInfoReaderCompressorWithMetrics
implements IDeviceInfoDataCompressor {
    private final IDeviceInfoDataCompressor _deviceInfoDataCompressor;
    private final Experiments _experiments;
    private long _startTimeInfo;
    private long _startTimeCompression;
    private long _endTime;

    public DeviceInfoReaderCompressorWithMetrics(IDeviceInfoDataCompressor deviceInfoDataCompressor, Experiments experiments) {
        this._deviceInfoDataCompressor = deviceInfoDataCompressor;
        this._experiments = experiments;
    }

    @Override
    public byte[] getDeviceData() {
        if (this._deviceInfoDataCompressor == null) {
            return new byte[0];
        }
        this._startTimeInfo = System.currentTimeMillis();
        Map<String, Object> deviceInfo = this.getDeviceInfo();
        byte[] zippedData = this.compressDeviceInfo(deviceInfo);
        this.sendDeviceInfoMetrics();
        return zippedData;
    }

    @Override
    public Map<String, Object> getDeviceInfo() {
        return this._deviceInfoDataCompressor.getDeviceInfo();
    }

    @Override
    public byte[] compressDeviceInfo(Map<String, Object> deviceData) {
        this._startTimeCompression = System.currentTimeMillis();
        byte[] zippedData = this._deviceInfoDataCompressor.compressDeviceInfo(this.getDeviceInfo());
        this._endTime = System.currentTimeMillis();
        return zippedData;
    }

    private long getDeviceInfoCollectionDuration() {
        return this._startTimeCompression - this._startTimeInfo;
    }

    private long getCompressionDuration() {
        return this._endTime - this._startTimeCompression;
    }

    private void sendDeviceInfoMetrics() {
        Map<String, String> tags = null;
        if (this._experiments != null) {
            tags = this._experiments.getExperimentTags();
        }
        SDKMetrics.getInstance().sendMetric(TSIMetric.newDeviceInfoCollectionLatency(this.getDeviceInfoCollectionDuration(), tags));
        SDKMetrics.getInstance().sendMetric(TSIMetric.newDeviceInfoCompressionLatency(this.getCompressionDuration(), tags));
    }
}

