/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import android.annotation.TargetApi;
import android.app.Application;
import android.os.Build;
import android.os.ConditionVariable;
import android.text.TextUtils;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.api.DownloadLatestWebViewStatus;
import com.unity3d.services.core.api.Lifecycle;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationLoader;
import com.unity3d.services.core.configuration.Experiments;
import com.unity3d.services.core.configuration.IConfigurationLoaderListener;
import com.unity3d.services.core.configuration.IModuleConfiguration;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.connectivity.ConnectivityMonitor;
import com.unity3d.services.core.connectivity.IConnectivityListener;
import com.unity3d.services.core.lifecycle.CachedLifecycle;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.WebRequest;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.request.metrics.TSIMetric;
import com.unity3d.services.core.webview.WebViewApp;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class InitializeThread
extends Thread {
    private static InitializeThread _thread;
    private InitializeState _state;
    private boolean _stopThread = false;

    private InitializeThread(InitializeState state) {
        this._state = state;
    }

    @Override
    public void run() {
        try {
            while (this._state != null && !this._stopThread) {
                String message;
                try {
                    this._state = this._state.execute();
                }
                catch (Exception e) {
                    message = "Unity Ads SDK encountered an error during initialization, cancel initialization";
                    DeviceLog.exception("Unity Ads SDK encountered an error during initialization, cancel initialization", e);
                    Utilities.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK encountered an error during initialization, cancel initialization");
                        }
                    });
                    this._state = new InitializeStateForceReset();
                }
                catch (OutOfMemoryError oom) {
                    message = "Unity Ads SDK failed to initialize due to application doesn't have enough memory to initialize Unity Ads SDK";
                    DeviceLog.exception("Unity Ads SDK failed to initialize due to application doesn't have enough memory to initialize Unity Ads SDK", new Exception(oom));
                    Utilities.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to application doesn't have enough memory to initialize Unity Ads SDK");
                        }
                    });
                    this._state = new InitializeStateForceReset();
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
        _thread = null;
    }

    public void quit() {
        this._stopThread = true;
    }

    public static synchronized void initialize(Configuration configuration) {
        if (_thread == null) {
            InitializeEventsMetricSender.getInstance().didInitStart();
            CachedLifecycle.register();
            _thread = new InitializeThread(new InitializeStateLoadConfigFile(configuration));
            _thread.setName("UnityAdsInitializeThread");
            _thread.start();
        }
    }

    public static synchronized void reset() {
        if (_thread == null) {
            _thread = new InitializeThread(new InitializeStateForceReset());
            _thread.setName("UnityAdsResetThread");
            _thread.start();
        }
    }

    public static synchronized DownloadLatestWebViewStatus downloadLatestWebView() {
        if (_thread != null) {
            return DownloadLatestWebViewStatus.INIT_QUEUE_NOT_EMPTY;
        }
        if (SdkProperties.getLatestConfiguration() == null) {
            return DownloadLatestWebViewStatus.MISSING_LATEST_CONFIG;
        }
        _thread = new InitializeThread(new InitializeStateCheckForCachedWebViewUpdate(SdkProperties.getLatestConfiguration()));
        _thread.setName("UnityAdsDownloadThread");
        _thread.start();
        return DownloadLatestWebViewStatus.BACKGROUND_DOWNLOAD_STARTED;
    }

    private static byte[] loadCachedFileToByteArray(File fileToLoad) throws IOException {
        if (fileToLoad != null && fileToLoad.exists()) {
            try {
                return Utilities.readFileBytes(fileToLoad);
            }
            catch (IOException e) {
                throw new IOException("could not read from file");
            }
        }
        throw new IOException("file not found");
    }

    public static class InitializeStateCheckForCachedWebViewUpdate
    extends InitializeState {
        private Configuration _configuration;

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public InitializeStateCheckForCachedWebViewUpdate(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            try {
                byte[] localWebViewData = InitializeThread.loadCachedFileToByteArray(new File(SdkProperties.getLocalWebViewFile()));
                String localWebViewHash = Utilities.Sha256(localWebViewData);
                if (localWebViewHash.equals(this._configuration.getWebViewHash())) {
                    String localWebViewDataString = new String(localWebViewData, "UTF-8");
                    return new InitializeStateUpdateCache(this._configuration, localWebViewDataString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new InitializeStateDownloadWebView(this._configuration);
        }
    }

    public static class InitializeStateUpdateCache
    extends InitializeState {
        private Configuration _configuration;
        private String _webViewData;

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public InitializeStateUpdateCache(Configuration configuration, String webViewData) {
            this._configuration = configuration;
            this._webViewData = webViewData;
        }

        @Override
        public InitializeState execute() {
            if (this._configuration != null && this._webViewData != null) {
                try {
                    Utilities.writeFile(new File(SdkProperties.getLocalWebViewFile()), this._webViewData);
                    Utilities.writeFile(new File(SdkProperties.getLocalConfigurationFilepath()), this._configuration.getJSONString());
                }
                catch (Exception exception) {
                    return new InitializeStateCleanCacheIgnoreError(this._configuration, null);
                }
            }
            return null;
        }
    }

    public static class InitializeStateDownloadWebView
    extends InitializeState {
        private Configuration _configuration;
        private int _retries;
        private long _retryDelay;

        public InitializeStateDownloadWebView(Configuration configuration) {
            this._configuration = configuration;
            this._retries = 0;
            this._retryDelay = configuration.getRetryDelay();
        }

        @Override
        public InitializeState execute() {
            String webViewData;
            WebRequest request;
            DeviceLog.info("Unity Ads init: downloading webapp from " + this._configuration.getWebViewUrl());
            try {
                request = new WebRequest(this._configuration.getWebViewUrl(), "GET", null);
            }
            catch (Exception e) {
                DeviceLog.exception("Malformed URL", e);
                return null;
            }
            try {
                webViewData = request.makeRequest();
            }
            catch (Exception e) {
                if (this._retries < this._configuration.getMaxRetries()) {
                    this._retryDelay = (long)((double)this._retryDelay * this._configuration.getRetryScalingFactor());
                    ++this._retries;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return null;
            }
            String webViewHash = this._configuration.getWebViewHash();
            if (webViewData != null && webViewHash != null && Utilities.Sha256(webViewData).equals(webViewHash)) {
                return new InitializeStateUpdateCache(this._configuration, webViewData);
            }
            return null;
        }
    }

    public static class InitializeStateCheckForUpdatedWebView
    extends InitializeState {
        private Configuration _configuration;
        private byte[] _localWebViewData;
        private Configuration _localWebViewConfiguration;

        public InitializeStateCheckForUpdatedWebView(Configuration configuration, byte[] localWebViewData, Configuration localWebViewConfiguration) {
            this._configuration = configuration;
            this._localWebViewData = localWebViewData;
            this._localWebViewConfiguration = localWebViewConfiguration;
        }

        @Override
        public InitializeState execute() {
            try {
                String localWebViewHash = Utilities.Sha256(this._localWebViewData);
                if (!localWebViewHash.equals(this._configuration.getWebViewHash())) {
                    SdkProperties.setLatestConfiguration(this._configuration);
                }
                if (!TextUtils.isEmpty((CharSequence)localWebViewHash)) {
                    if (this._localWebViewConfiguration != null && this._localWebViewConfiguration.getWebViewHash() != null && this._localWebViewConfiguration.getWebViewHash().equals(localWebViewHash) && SdkProperties.getVersionName().equals(this._localWebViewConfiguration.getSdkVersion())) {
                        String localWebViewData = new String(this._localWebViewData, "UTF-8");
                        return new InitializeStateCreate(this._localWebViewConfiguration, localWebViewData);
                    }
                    if (this._configuration != null && this._configuration.getWebViewHash().equals(localWebViewHash)) {
                        String localWebViewData = new String(this._localWebViewData, "UTF-8");
                        return new InitializeStateCreate(this._configuration, localWebViewData);
                    }
                }
            }
            catch (Exception localWebViewHash) {
                // empty catch block
            }
            InitializeStateLoadWeb initializeStateLoadWeb = new InitializeStateLoadWeb(this._configuration);
            return new InitializeStateCleanCache(this._configuration, initializeStateLoadWeb);
        }
    }

    public static class InitializeStateCleanCacheIgnoreError
    extends InitializeStateCleanCache {
        public InitializeStateCleanCacheIgnoreError(Configuration configuration, InitializeState nextState) {
            super(configuration, nextState);
        }

        @Override
        public InitializeState execute() {
            try {
                InitializeState state = super.execute();
                if (!(state instanceof InitializeStateError)) {
                    return state;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    public static class InitializeStateCleanCache
    extends InitializeState {
        private Configuration _configuration;
        private InitializeState _nextState;

        public InitializeStateCleanCache(Configuration configuration, InitializeState nextState) {
            this._configuration = configuration;
            this._nextState = nextState;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            try {
                File localConfig = new File(SdkProperties.getLocalConfigurationFilepath());
                File localWebView = new File(SdkProperties.getLocalWebViewFile());
                localConfig.delete();
                localWebView.delete();
            }
            catch (Exception exception) {
                DeviceLog.error("Failure trying to clean cache: " + exception.getMessage());
            }
            return this._nextState;
        }
    }

    public static class InitializeStateLoadCacheConfigAndWebView
    extends InitializeState {
        private Configuration _configuration;
        private Configuration _localConfig;

        public InitializeStateLoadCacheConfigAndWebView(Configuration configuration, Configuration localConfig) {
            this._configuration = configuration;
            this._localConfig = localConfig;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            try {
                byte[] localWebViewData = InitializeThread.loadCachedFileToByteArray(new File(SdkProperties.getLocalWebViewFile()));
                return new InitializeStateCheckForUpdatedWebView(this._configuration, localWebViewData, this._localConfig);
            }
            catch (Exception localWebViewData) {
                InitializeStateLoadWeb initializeStateLoadWeb = new InitializeStateLoadWeb(this._configuration);
                return new InitializeStateCleanCache(this._configuration, initializeStateLoadWeb);
            }
        }
    }

    public static class InitializeStateRetry
    extends InitializeState {
        InitializeState _state;
        long _delay;

        public InitializeStateRetry(InitializeState state, long delay) {
            this._state = state;
            this._delay = delay;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.debug("Unity Ads init: retrying in " + this._delay + " milliseconds");
            try {
                Thread.sleep(this._delay);
            }
            catch (Exception e) {
                DeviceLog.exception("Init retry interrupted", e);
            }
            return this._state;
        }
    }

    public static class InitializeStateNetworkError
    extends InitializeStateError
    implements IConnectivityListener {
        private static int _receivedConnectedEvents;
        private static long _lastConnectedEventTimeMs;
        private String _state;
        private InitializeState _erroredState;
        private ConditionVariable _conditionVariable;
        private long _networkErrorTimeout;
        private int _maximumConnectedEvents;
        private int _connectedEventThreshold;

        public InitializeStateNetworkError(String state, Exception exception, InitializeState errorState, Configuration configuration) {
            super(state, exception, configuration);
            this._state = state;
            _receivedConnectedEvents = 0;
            _lastConnectedEventTimeMs = 0L;
            this._erroredState = errorState;
            this._networkErrorTimeout = configuration.getNetworkErrorTimeout();
            this._maximumConnectedEvents = configuration.getMaximumConnectedEvents();
            this._connectedEventThreshold = configuration.getConnectedEventThreshold();
        }

        @Override
        public InitializeState execute() {
            DeviceLog.error("Unity Ads init: network error, waiting for connection events");
            this._conditionVariable = new ConditionVariable();
            ConnectivityMonitor.addListener(this);
            if (this._conditionVariable.block(this._networkErrorTimeout)) {
                ConnectivityMonitor.removeListener(this);
                return this._erroredState;
            }
            ConnectivityMonitor.removeListener(this);
            return new InitializeStateError(this._state, new Exception("No connected events within the timeout!"), this._configuration);
        }

        @Override
        public void onConnected() {
            ++_receivedConnectedEvents;
            DeviceLog.debug("Unity Ads init got connected event");
            if (this.shouldHandleConnectedEvent()) {
                this._conditionVariable.open();
            }
            if (_receivedConnectedEvents > this._maximumConnectedEvents) {
                ConnectivityMonitor.removeListener(this);
            }
            _lastConnectedEventTimeMs = System.currentTimeMillis();
        }

        @Override
        public void onDisconnected() {
            DeviceLog.debug("Unity Ads init got disconnected event");
        }

        private boolean shouldHandleConnectedEvent() {
            return System.currentTimeMillis() - _lastConnectedEventTimeMs >= (long)this._connectedEventThreshold && _receivedConnectedEvents <= this._maximumConnectedEvents;
        }
    }

    public static class InitializeStateError
    extends InitializeState {
        String _state;
        Exception _exception;
        protected Configuration _configuration;

        public InitializeStateError(String state, Exception exception, Configuration configuration) {
            this._state = state;
            this._exception = exception;
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.error("Unity Ads init: halting init in " + this._state + ": " + this._exception.getMessage());
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null) continue;
                moduleConfiguration.initErrorState(this._configuration, this._state, this._exception.getMessage());
            }
            SDKMetrics.getInstance().sendEvent("native_initialization_failed", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("stt", InitializeStateError.this._state.replaceAll(" ", "_"));
                }
            });
            return null;
        }
    }

    public static class InitializeStateComplete
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateComplete(Configuration configuration) {
            this._configuration = configuration;
        }

        @Override
        public InitializeState execute() {
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null) continue;
                moduleConfiguration.initCompleteState(this._configuration);
            }
            return null;
        }
    }

    public static class InitializeStateCreate
    extends InitializeState {
        private Configuration _configuration;
        private String _webViewData;
        public static final String InitializeStateCreateStateName = "create webapp";

        public InitializeStateCreate(Configuration configuration, String webViewData) {
            this._configuration = configuration;
            this._webViewData = webViewData;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        public String getWebData() {
            return this._webViewData;
        }

        @Override
        public InitializeState execute() {
            boolean createSuccessFull;
            DeviceLog.debug("Unity Ads init: creating webapp");
            Configuration configuration = this._configuration;
            configuration.setWebViewData(this._webViewData);
            try {
                createSuccessFull = WebViewApp.create(configuration);
            }
            catch (IllegalThreadStateException e) {
                DeviceLog.exception("Illegal Thread", e);
                return new InitializeStateError(InitializeStateCreateStateName, e, this._configuration);
            }
            if (createSuccessFull) {
                return new InitializeStateComplete(this._configuration);
            }
            String errorMessage = "Unity Ads WebApp creation failed";
            if (WebViewApp.getCurrentApp().getWebAppFailureMessage() != null) {
                errorMessage = WebViewApp.getCurrentApp().getWebAppFailureMessage();
            }
            DeviceLog.error(errorMessage);
            return new InitializeStateError(InitializeStateCreateStateName, new Exception(errorMessage), this._configuration);
        }
    }

    public static class InitializeStateLoadWeb
    extends InitializeState {
        private Configuration _configuration;
        private int _retries;
        private long _retryDelay;
        private int _maxRetries;
        private double _scalingFactor;

        public InitializeStateLoadWeb(Configuration configuration) {
            this._configuration = configuration;
            this._retries = 0;
            this._retryDelay = configuration.getRetryDelay();
            this._maxRetries = configuration.getMaxRetries();
            this._scalingFactor = configuration.getRetryScalingFactor();
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            String webViewData;
            WebRequest request;
            DeviceLog.info("Unity Ads init: loading webapp from " + this._configuration.getWebViewUrl());
            try {
                request = new WebRequest(this._configuration.getWebViewUrl(), "GET", null);
            }
            catch (MalformedURLException e) {
                DeviceLog.exception("Malformed URL", e);
                return new InitializeStateError("malformed webview request", e, this._configuration);
            }
            try {
                webViewData = request.makeRequest();
            }
            catch (Exception e) {
                if (this._retries < this._maxRetries) {
                    this._retryDelay = (long)((double)this._retryDelay * this._scalingFactor);
                    ++this._retries;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError("network webview request", e, this, this._configuration);
            }
            String webViewHash = this._configuration.getWebViewHash();
            if (webViewHash != null && !Utilities.Sha256(webViewData).equals(webViewHash)) {
                return new InitializeStateError("invalid hash", new Exception("Invalid webViewHash"), this._configuration);
            }
            if (webViewHash != null) {
                Utilities.writeFile(new File(SdkProperties.getLocalWebViewFile()), webViewData);
            }
            return new InitializeStateCreate(this._configuration, webViewData);
        }
    }

    public static class InitializeStateLoadCache
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateLoadCache(Configuration configuration) {
            this._configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            byte[] localWebViewData;
            DeviceLog.debug("Unity Ads init: check if webapp can be loaded from local cache");
            try {
                localWebViewData = Utilities.readFileBytes(new File(SdkProperties.getLocalWebViewFile()));
            }
            catch (Exception e) {
                DeviceLog.debug("Unity Ads init: webapp not found in local cache: " + e.getMessage());
                return new InitializeStateLoadWeb(this._configuration);
            }
            String localWebViewHash = Utilities.Sha256(localWebViewData);
            if (localWebViewHash != null && localWebViewHash.equals(this._configuration.getWebViewHash())) {
                String webViewDataString;
                try {
                    webViewDataString = new String(localWebViewData, "UTF-8");
                }
                catch (Exception e) {
                    return new InitializeStateError("load cache", e, this._configuration);
                }
                DeviceLog.info("Unity Ads init: webapp loaded from local cache");
                return new InitializeStateCreate(this._configuration, webViewDataString);
            }
            return new InitializeStateLoadWeb(this._configuration);
        }
    }

    public static class InitializeStateConfig
    extends InitializeState {
        private Configuration _configuration;
        private Configuration _localConfig;
        private int _retries;
        private long _retryDelay;
        private int _maxRetries;
        private double _scalingFactor;
        private InitializeState _nextState;

        public InitializeStateConfig(Configuration localConfiguration) {
            this._configuration = new Configuration(SdkProperties.getConfigUrl(), localConfiguration.getExperiments());
            this._retries = 0;
            this._retryDelay = localConfiguration.getRetryDelay();
            this._maxRetries = localConfiguration.getMaxRetries();
            this._scalingFactor = localConfiguration.getRetryScalingFactor();
            this._localConfig = localConfiguration;
            this._nextState = null;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.info("Unity Ads init: load configuration from " + SdkProperties.getConfigUrl());
            InitializeState nextState = this._configuration.getExperiments() != null && this._configuration.getExperiments().isTwoStageInitializationEnabled() ? this.executeWithLoader() : this.executeLegacy(this._configuration);
            return nextState;
        }

        public InitializeState executeLegacy(Configuration configuration) {
            try {
                configuration.makeRequest();
            }
            catch (Exception e) {
                if (this._retries < this._maxRetries) {
                    this._retryDelay = (long)((double)this._retryDelay * this._scalingFactor);
                    ++this._retries;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError("network config request", e, this, this._localConfig);
            }
            if (configuration.getDelayWebViewUpdate()) {
                return new InitializeStateLoadCacheConfigAndWebView(configuration, this._localConfig);
            }
            return new InitializeStateLoadCache(configuration);
        }

        public InitializeState executeWithLoader() {
            ConfigurationLoader configurationLoader = new ConfigurationLoader(this._configuration);
            final Configuration legacyConfiguration = new Configuration(SdkProperties.getConfigUrl(), new Experiments());
            try {
                configurationLoader.loadConfiguration(new IConfigurationLoaderListener(){

                    @Override
                    public void onSuccess(Configuration configuration) {
                        InitializeStateConfig.this._configuration = configuration;
                        if (InitializeStateConfig.this._configuration.getDelayWebViewUpdate()) {
                            InitializeStateConfig.this._nextState = new InitializeStateLoadCacheConfigAndWebView(InitializeStateConfig.this._configuration, InitializeStateConfig.this._localConfig);
                        }
                        TokenStorage.setInitToken(InitializeStateConfig.this._configuration.getUnifiedAuctionToken());
                        InitializeStateConfig.this._configuration.saveToDisk();
                        InitializeStateConfig.this._nextState = new InitializeStateLoadCache(InitializeStateConfig.this._configuration);
                    }

                    @Override
                    public void onError(String errorMsg) {
                        SDKMetrics.getInstance().sendMetric(TSIMetric.newEmergencySwitchOff(InitializeStateConfig.this._configuration.getMetricTags()));
                        InitializeStateConfig.this._nextState = InitializeStateConfig.this.executeLegacy(legacyConfiguration);
                    }
                });
                return this._nextState;
            }
            catch (Exception e) {
                if (this._retries < this._maxRetries) {
                    this._retryDelay = (long)((double)this._retryDelay * this._scalingFactor);
                    ++this._retries;
                    return new InitializeStateRetry(this, this._retryDelay);
                }
                return new InitializeStateNetworkError("network config request", e, this, this._configuration);
            }
        }
    }

    public static class InitializeStateInitModules
    extends InitializeState {
        private Configuration _configuration;
        public static final String InitializeStateInitModuleStateName = "init modules";

        public InitializeStateInitModules(Configuration configuration) {
            this._configuration = configuration;
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null || moduleConfiguration.initModuleState(this._configuration)) continue;
                return new InitializeStateError(InitializeStateInitModuleStateName, new Exception("Unity Ads config server resolves to loopback address (due to ad blocker?)"), this._configuration);
            }
            return new InitializeStateConfig(this._configuration);
        }
    }

    public static class InitializeStateForceReset
    extends InitializeStateReset {
        public InitializeStateForceReset() {
            super(new Configuration());
        }

        @Override
        public InitializeState execute() {
            SdkProperties.setInitializeState(SdkProperties.InitializationState.NOT_INITIALIZED);
            super.execute();
            return null;
        }
    }

    public static class InitializeStateReset
    extends InitializeState {
        private Configuration _configuration;
        private int _resetWebAppTimeout;

        public InitializeStateReset(Configuration configuration) {
            this._configuration = configuration;
            this._resetWebAppTimeout = configuration.getResetWebappTimeout();
        }

        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public InitializeState execute() {
            DeviceLog.debug("Unity Ads init: starting init");
            final ConditionVariable cv = new ConditionVariable();
            final WebViewApp currentApp = WebViewApp.getCurrentApp();
            boolean success = true;
            if (currentApp != null) {
                currentApp.resetWebViewAppInitialization();
                if (currentApp.getWebView() != null) {
                    Utilities.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            currentApp.getWebView().destroy();
                            currentApp.setWebView(null);
                            cv.open();
                        }
                    });
                    success = cv.block((long)this._resetWebAppTimeout);
                }
                if (!success) {
                    return new InitializeStateError("reset webapp", new Exception("Reset failed on opening ConditionVariable"), this._configuration);
                }
            }
            if (Build.VERSION.SDK_INT > 13) {
                this.unregisterLifecycleCallbacks();
            }
            SdkProperties.setCacheDirectory(null);
            File cacheDir = SdkProperties.getCacheDirectory();
            if (cacheDir == null) {
                return new InitializeStateError("reset webapp", new Exception("Cache directory is NULL"), this._configuration);
            }
            SdkProperties.setInitialized(false);
            for (String moduleName : this._configuration.getModuleConfigurationList()) {
                IModuleConfiguration moduleConfiguration = this._configuration.getModuleConfiguration(moduleName);
                if (moduleConfiguration == null) continue;
                moduleConfiguration.resetState(this._configuration);
            }
            return new InitializeStateInitModules(this._configuration);
        }

        @TargetApi(value=14)
        private void unregisterLifecycleCallbacks() {
            if (Lifecycle.getLifecycleListener() != null) {
                if (ClientProperties.getApplication() != null) {
                    ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                }
                Lifecycle.setLifecycleListener(null);
            }
        }
    }

    public static class InitializeStateLoadConfigFile
    extends InitializeState {
        private Configuration _configuration;

        public InitializeStateLoadConfigFile(Configuration configuration) {
            this._configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InitializeState execute() {
            DeviceLog.debug("Unity Ads init: Loading Config File Parameters");
            Configuration localConfig = null;
            File configFile = new File(SdkProperties.getLocalConfigurationFilepath());
            if (!configFile.exists()) {
                return new InitializeStateReset(this._configuration);
            }
            try {
                String fileContent = new String(Utilities.readFileBytes(configFile));
                JSONObject loadedJson = new JSONObject(fileContent);
                this._configuration = localConfig = new Configuration(loadedJson);
                return this._configuration;
            }
            catch (Exception e) {
                DeviceLog.debug("Unity Ads init: Using default configuration parameters");
            }
            finally {
                return new InitializeStateReset(this._configuration);
            }
        }
    }

    private static abstract class InitializeState {
        private InitializeState() {
        }

        public abstract InitializeState execute();
    }
}

