/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.show;

import android.os.ConditionVariable;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.show.IShowModule;
import com.unity3d.services.ads.operation.show.IShowOperation;
import com.unity3d.services.ads.operation.show.ShowModuleDecorator;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.core.request.metrics.SDKMetricEvents;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ShowModuleDecoratorTimeout
extends ShowModuleDecorator {
    private static String errorMsgTimeout = "[UnityAds] Timeout while trying to show ";
    private ExecutorService _executorService = Executors.newSingleThreadExecutor();

    public ShowModuleDecoratorTimeout(IShowModule showModule) {
        super(showModule);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, ShowOperationState state) {
        this.startShowTimeout(state);
        super.executeAdOperation(webViewBridgeInvoker, state);
    }

    private void startShowTimeout(final ShowOperationState showOperationState) {
        this._executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (!showOperationState.timeoutCV.block((long)showOperationState.configuration.getShowTimeout())) {
                    ShowModuleDecoratorTimeout.this.onOperationTimeout(showOperationState, UnityAds.UnityAdsShowError.INTERNAL_ERROR, errorMsgTimeout + showOperationState.placementId);
                }
            }
        });
    }

    @Override
    public void onUnityAdsShowConsent(String id) {
        this.releaseOperationTimeoutLock(id);
        super.onUnityAdsShowConsent(id);
    }

    @Override
    public void onUnityAdsShowFailure(String id, UnityAds.UnityAdsShowError error, String message) {
        this.releaseOperationTimeoutLock(id);
        super.onUnityAdsShowFailure(id, error, message);
    }

    @Override
    public void onUnityAdsShowStart(String id) {
        this.releaseOperationTimeoutLock(id);
        super.onUnityAdsShowStart(id);
    }

    private void releaseOperationTimeoutLock(String operationId) {
        IShowOperation showOperation = this.get(operationId);
        if (showOperation == null) {
            return;
        }
        ShowOperationState showOperationState = showOperation.getShowOperationState();
        if (showOperationState == null) {
            return;
        }
        ConditionVariable timeoutCV = showOperation.getShowOperationState().timeoutCV;
        if (timeoutCV == null) {
            return;
        }
        showOperation.getShowOperationState().timeoutCV.open();
    }

    private void onOperationTimeout(ShowOperationState state, UnityAds.UnityAdsShowError error, String message) {
        this.remove(state.id);
        state.listener.onUnityAdsShowFailure(state.placementId, error, message);
        this.getMetricSender().sendSDKMetricEvent(SDKMetricEvents.native_show_timeout_error);
    }
}

