/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads;

import android.app.Activity;
import android.content.Context;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.services.UnityServices;
import com.unity3d.services.ads.operation.load.LoadModule;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.ads.operation.show.ShowModule;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.WebViewBridgeInvoker;

public final class UnityAdsImplementation {
    private static Configuration configuration = null;
    private static WebViewBridgeInvoker webViewBridgeInvoker = new WebViewBridgeInvoker();

    public static void initialize(Context context, String gameId, IUnityAdsInitializationListener initializationListener) {
        boolean testMode = false;
        UnityAdsImplementation.initialize(context, gameId, testMode, initializationListener);
    }

    public static void initialize(Context context, String gameId, boolean testMode) {
        UnityAdsImplementation.initialize(context, gameId, testMode, null);
    }

    public static void initialize(Context context, String gameId, boolean testMode, IUnityAdsInitializationListener initializationListener) {
        DeviceLog.entered();
        UnityServices.initialize(context, gameId, testMode, initializationListener);
    }

    public static boolean isInitialized() {
        return UnityServices.isInitialized();
    }

    public static boolean isSupported() {
        return UnityServices.isSupported();
    }

    public static String getVersion() {
        return UnityServices.getVersion();
    }

    public static void show(Activity activity, String placementId) {
        UnityAdsImplementation.show(activity, placementId, new UnityAdsShowOptions(), null);
    }

    public static void show(Activity activity, String placementId, IUnityAdsShowListener showListener) {
        UnityAdsImplementation.show(activity, placementId, new UnityAdsShowOptions(), showListener);
    }

    public static void show(Activity activity, String placementId, UnityAdsShowOptions showOptions, IUnityAdsShowListener showListener) {
        if (!UnityAdsImplementation.isSupported()) {
            String showErrorMessage = "Unity Ads is not supported for this device";
            UnityAdsImplementation.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
            return;
        }
        if (!UnityAdsImplementation.isInitialized()) {
            String showErrorMessage = "Unity Ads is not initialized";
            UnityAdsImplementation.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
            return;
        }
        if (activity == null) {
            String showErrorMessage = "Activity must not be null";
            UnityAdsImplementation.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.INVALID_ARGUMENT, showErrorMessage);
            return;
        }
        Configuration config = configuration == null ? new Configuration() : configuration;
        ClientProperties.setActivity(activity);
        ShowModule.getInstance().executeAdOperation(WebViewApp.getCurrentApp(), new ShowOperationState(placementId, showListener, activity, showOptions, config));
    }

    private static void handleShowError(IUnityAdsShowListener showListener, String placementId, UnityAds.UnityAdsShowError error, String message) {
        if (showListener == null) {
            return;
        }
        showListener.onUnityAdsShowFailure(placementId, error, message);
    }

    public static void setDebugMode(boolean debugMode) {
        UnityServices.setDebugMode(debugMode);
    }

    public static boolean getDebugMode() {
        return UnityServices.getDebugMode();
    }

    public static void load(String placementId, UnityAdsLoadOptions loadOptions, IUnityAdsLoadListener listener) {
        Configuration config = configuration == null ? new Configuration() : configuration;
        LoadModule.getInstance().executeAdOperation(webViewBridgeInvoker, new LoadOperationState(placementId, listener, loadOptions, config));
    }

    public static String getToken() {
        return TokenStorage.getToken();
    }

    public static void setConfiguration(Configuration configuration) {
        UnityAdsImplementation.configuration = configuration;
    }
}

