/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.listeners;

import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.store.StoreEvent;
import com.unity3d.services.store.gpbl.BillingResultResponseCode;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseBridge;
import com.unity3d.services.store.listeners.IPurchasesResponseListener;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class PurchasesResponseListener
implements IPurchasesResponseListener {
    private final Integer _operationId;
    private final StoreEvent _successEvent;
    private final StoreEvent _errorEvent;

    public PurchasesResponseListener(StoreEvent successEvent, StoreEvent errorEvent) {
        this(null, successEvent, errorEvent);
    }

    public PurchasesResponseListener(Integer operationId, StoreEvent successEvent, StoreEvent errorEvent) {
        this._operationId = operationId;
        this._successEvent = successEvent;
        this._errorEvent = errorEvent;
    }

    @Override
    public void onBillingResponse(BillingResultBridge billingResult, List<PurchaseBridge> purchases) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this._operationId != null) {
            params.add(this._operationId);
        }
        if (billingResult.getResponseCode() == BillingResultResponseCode.OK) {
            JSONArray purchasesJson = new JSONArray();
            for (PurchaseBridge purchaseBridge : purchases) {
                purchasesJson.put((Object)purchaseBridge.toJson());
            }
            params.add(purchasesJson);
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, this._successEvent, params.toArray());
        } else {
            params.add((Object)billingResult.getResponseCode());
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.STORE, this._errorEvent, params.toArray());
        }
    }
}

