/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.proxies;

import com.unity3d.services.core.reflection.GenericListenerProxy;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.PurchaseHistoryRecordBridge;
import com.unity3d.services.store.listeners.IPurchaseHistoryResponseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PurchaseHistoryResponseListenerProxy
extends GenericListenerProxy {
    private static final String onPurchaseHistoryResponseMethodName = "onPurchaseHistoryResponse";
    private IPurchaseHistoryResponseListener _purchaseUpdatedResponseListener;
    private int _maxPurchases;

    public PurchaseHistoryResponseListenerProxy(IPurchaseHistoryResponseListener purchaseHistoryResponseListener, int maxPurchases) {
        this._purchaseUpdatedResponseListener = purchaseHistoryResponseListener;
        this._maxPurchases = maxPurchases;
    }

    @Override
    public Class<?> getProxyClass() throws ClassNotFoundException {
        return PurchaseHistoryResponseListenerProxy.getProxyListenerClass();
    }

    public static Class<?> getProxyListenerClass() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.PurchaseHistoryResponseListener");
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result = null;
        if (m.getName().equals(onPurchaseHistoryResponseMethodName)) {
            this.onPurchaseHistoryResponse(args[0], (List)args[1]);
        } else {
            result = super.invoke(proxy, m, args);
        }
        return result;
    }

    public void onPurchaseHistoryResponse(Object billingResult, List<Object> purchaseHistoryRecordList) {
        ArrayList<PurchaseHistoryRecordBridge> purchaseHistoryRecordBridges = new ArrayList<PurchaseHistoryRecordBridge>();
        for (int purchaseCount = 0; purchaseCount < this._maxPurchases || purchaseCount < purchaseHistoryRecordList.size(); ++purchaseCount) {
            purchaseHistoryRecordBridges.add(new PurchaseHistoryRecordBridge(purchaseHistoryRecordList.get(purchaseCount)));
        }
        if (this._purchaseUpdatedResponseListener != null) {
            this._purchaseUpdatedResponseListener.onBillingResponse(new BillingResultBridge(billingResult), (List<PurchaseHistoryRecordBridge>)purchaseHistoryRecordBridges);
        }
    }
}

