/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.bridges;

import com.unity3d.services.ads.gmascar.bridges.AdapterStatusStateBridge;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.reflection.GenericBridge;
import java.util.HashMap;
import java.util.Map;

public class AdapterStatusBridge
extends GenericBridge {
    private static final String initializeStateMethodName = "getInitializationState";
    private Class _adapterStateClass;

    public AdapterStatusBridge() {
        super((Map<String, Class[]>)new HashMap<String, Class[]>(){
            {
                this.put(AdapterStatusBridge.initializeStateMethodName, new Class[0]);
            }
        });
        AdapterStatusStateBridge adapterStatusStateBridge = new AdapterStatusStateBridge();
        try {
            this._adapterStateClass = Class.forName(adapterStatusStateBridge.getClassName());
        }
        catch (ClassNotFoundException e) {
            DeviceLog.debug("ERROR: Could not find class %s %s", adapterStatusStateBridge.getClassName(), e.getLocalizedMessage());
        }
    }

    @Override
    protected String getClassName() {
        return "com.google.android.gms.ads.initialization.AdapterStatus";
    }

    public boolean isGMAInitialized(Object adapterState) {
        Object[] states = this.getAdapterStatesEnum();
        if (states == null) {
            DeviceLog.debug("ERROR: Could not get adapter states enum from AdapterStatus.State");
            return false;
        }
        return this.callNonVoidMethod(initializeStateMethodName, adapterState, new Object[0]) == states[1];
    }

    public Object[] getAdapterStatesEnum() {
        return this._adapterStateClass.getEnumConstants();
    }
}

