/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads;

import android.app.Activity;
import android.content.Context;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.ads.properties.AdsProperties;
import com.unity3d.services.IUnityServicesListener;
import com.unity3d.services.UnityServices;
import com.unity3d.services.ads.operation.load.LoadModule;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.ads.operation.show.ShowModule;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.ads.placement.Placement;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.WebViewBridgeInvoker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class UnityAdsImplementation {
    static ExecutorService _showExecutorService = Executors.newSingleThreadExecutor();
    private static Configuration configuration = null;
    private static WebViewBridgeInvoker webViewBridgeInvoker = new WebViewBridgeInvoker();

    public static void initialize(Context context, String gameId, IUnityAdsListener listener) {
        boolean testMode = false;
        UnityAdsImplementation.initialize(context, gameId, listener, testMode);
    }

    public static void initialize(Context context, String gameId, IUnityAdsListener listener, boolean testMode) {
        boolean usePerPlacementLoad = false;
        UnityAdsImplementation.initialize(context, gameId, listener, testMode, usePerPlacementLoad, null);
    }

    public static void initialize(Context context, String gameId, final IUnityAdsListener listener, boolean testMode, boolean enablePerPlacementLoad, IUnityAdsInitializationListener initializationListener) {
        DeviceLog.entered();
        UnityAdsImplementation.addListener(listener);
        UnityServices.initialize(context, gameId, new IUnityServicesListener(){

            @Override
            public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
                if (listener == null) {
                    return;
                }
                if (error == UnityServices.UnityServicesError.INIT_SANITY_CHECK_FAIL) {
                    listener.onUnityAdsError(UnityAds.UnityAdsError.INIT_SANITY_CHECK_FAIL, message);
                } else if (error == UnityServices.UnityServicesError.INVALID_ARGUMENT) {
                    listener.onUnityAdsError(UnityAds.UnityAdsError.INVALID_ARGUMENT, message);
                }
            }
        }, testMode, enablePerPlacementLoad, initializationListener);
    }

    public static boolean isInitialized() {
        return UnityServices.isInitialized();
    }

    @Deprecated
    public static void setListener(IUnityAdsListener listener) {
        AdsProperties.setListener(listener);
    }

    @Deprecated
    public static IUnityAdsListener getListener() {
        return AdsProperties.getListener();
    }

    public static void addListener(IUnityAdsListener listener) {
        AdsProperties.addListener(listener);
    }

    public static void removeListener(IUnityAdsListener listener) {
        AdsProperties.removeListener(listener);
    }

    public static boolean isSupported() {
        return UnityServices.isSupported();
    }

    public static String getVersion() {
        return UnityServices.getVersion();
    }

    public static boolean isReady() {
        return UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && Placement.isReady();
    }

    public static boolean isReady(String placementId) {
        return UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && placementId != null && Placement.isReady(placementId);
    }

    public static UnityAds.PlacementState getPlacementState() {
        if (UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized()) {
            return Placement.getPlacementState();
        }
        return UnityAds.PlacementState.NOT_AVAILABLE;
    }

    public static UnityAds.PlacementState getPlacementState(String placementId) {
        if (UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && placementId != null) {
            return Placement.getPlacementState(placementId);
        }
        return UnityAds.PlacementState.NOT_AVAILABLE;
    }

    public static void show(Activity activity) {
        if (Placement.getDefaultPlacement() != null) {
            UnityAdsImplementation.show(activity, Placement.getDefaultPlacement());
        } else {
            UnityAdsImplementation.handleLegacyListenerShowError("", UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads default placement is not initialized");
        }
    }

    public static void show(Activity activity, String placementId) {
        UnityAdsImplementation.show(activity, placementId, new UnityAdsShowOptions(), null);
    }

    public static void show(Activity activity, String placementId, IUnityAdsShowListener showListener) {
        UnityAdsImplementation.show(activity, placementId, new UnityAdsShowOptions(), showListener);
    }

    public static void show(Activity activity, String placementId, UnityAdsShowOptions showOptions, IUnityAdsShowListener showListener) {
        if (!UnityAdsImplementation.isSupported()) {
            String showErrorMessage = "Unity Ads is not supported for this device";
            UnityAdsImplementation.handleLegacyListenerShowError(placementId, UnityAds.UnityAdsError.NOT_INITIALIZED, showErrorMessage);
            UnityAdsImplementation.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
            return;
        }
        if (!UnityAdsImplementation.isInitialized()) {
            String showErrorMessage = "Unity Ads is not initialized";
            UnityAdsImplementation.handleLegacyListenerShowError(placementId, UnityAds.UnityAdsError.NOT_INITIALIZED, showErrorMessage);
            UnityAdsImplementation.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
            return;
        }
        if (activity == null) {
            String showErrorMessage = "Activity must not be null";
            UnityAdsImplementation.handleLegacyListenerShowError(placementId, UnityAds.UnityAdsError.INVALID_ARGUMENT, showErrorMessage);
            UnityAdsImplementation.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.INVALID_ARGUMENT, showErrorMessage);
            return;
        }
        Configuration config = configuration == null ? new Configuration() : configuration;
        ClientProperties.setActivity(activity);
        ShowModule.getInstance().executeAdOperation(WebViewApp.getCurrentApp(), new ShowOperationState(placementId, showListener, activity, showOptions, config));
    }

    private static void handleShowError(IUnityAdsShowListener showListener, String placementId, UnityAds.UnityAdsShowError error, String message) {
        if (showListener == null) {
            return;
        }
        showListener.onUnityAdsShowFailure(placementId, error, message);
    }

    private static void handleLegacyListenerShowError(final String placementId, final UnityAds.UnityAdsError error, String message) {
        final String errorMessage = "Unity Ads show failed: " + message;
        DeviceLog.error(errorMessage);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (IUnityAdsListener listener : AdsProperties.getListeners()) {
                    listener.onUnityAdsError(error, errorMessage);
                    if (placementId != null) {
                        listener.onUnityAdsFinish(placementId, UnityAds.FinishState.ERROR);
                        continue;
                    }
                    listener.onUnityAdsFinish("", UnityAds.FinishState.ERROR);
                }
            }
        });
    }

    public static void setDebugMode(boolean debugMode) {
        UnityServices.setDebugMode(debugMode);
    }

    public static boolean getDebugMode() {
        return UnityServices.getDebugMode();
    }

    public static void load(String placementId, UnityAdsLoadOptions loadOptions, IUnityAdsLoadListener listener) {
        Configuration config = configuration == null ? new Configuration() : configuration;
        LoadModule.getInstance().executeAdOperation(webViewBridgeInvoker, new LoadOperationState(placementId, listener, loadOptions, config));
    }

    public static String getToken() {
        return TokenStorage.getToken();
    }

    public static void setConfiguration(Configuration configuration) {
        UnityAdsImplementation.configuration = configuration;
    }
}

