/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.monetization.core.api;

import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import com.unity3d.services.monetization.IUnityMonetizationListener;
import com.unity3d.services.monetization.UnityMonetization;
import com.unity3d.services.monetization.core.placementcontent.PlacementContentListenerError;
import com.unity3d.services.monetization.core.placementcontent.PlacementContents;
import com.unity3d.services.monetization.core.properties.ClientProperties;
import com.unity3d.services.monetization.placementcontent.core.PlacementContent;

public class MonetizationListener {
    @WebViewExposed
    public static void isMonetizationEnabled(WebViewCallback callback) {
        callback.invoke(ClientProperties.isMonetizationEnabled());
    }

    @WebViewExposed
    public static void sendPlacementContentReady(String placementId, WebViewCallback callback) {
        IUnityMonetizationListener placementContentListener = ClientProperties.getListener();
        if (placementContentListener != null) {
            try {
                PlacementContent placementContent = PlacementContents.getPlacementContent(placementId);
                placementContentListener.onPlacementContentReady(placementId, placementContent);
                callback.invoke(new Object[0]);
            }
            catch (Exception e) {
                callback.error(PlacementContentListenerError.PLACEMENTCONTENT_LISTENER_ERROR, e);
            }
        } else {
            callback.error(PlacementContentListenerError.PLACEMENTCONTENT_LISTENER_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void sendPlacementContentStateChanged(String placementId, String previousState, String newState, WebViewCallback callback) {
        IUnityMonetizationListener placementContentListener = ClientProperties.getListener();
        if (placementContentListener != null) {
            try {
                PlacementContent placementContent = PlacementContents.getPlacementContent(placementId);
                placementContentListener.onPlacementContentStateChange(placementId, placementContent, UnityMonetization.PlacementContentState.valueOf(previousState), UnityMonetization.PlacementContentState.valueOf(newState));
                callback.invoke(new Object[0]);
            }
            catch (Exception e) {
                callback.error(PlacementContentListenerError.PLACEMENTCONTENT_LISTENER_ERROR, e);
            }
        } else {
            callback.error(PlacementContentListenerError.PLACEMENTCONTENT_LISTENER_NULL, new Object[0]);
        }
    }
}

