/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.connectivity;

import android.annotation.TargetApi;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import com.unity3d.services.core.connectivity.ConnectivityMonitor;
import com.unity3d.services.core.properties.ClientProperties;

@TargetApi(value=21)
public class ConnectivityNetworkCallback
extends ConnectivityManager.NetworkCallback {
    private static ConnectivityNetworkCallback _impl = null;

    public static void register() {
        if (_impl == null) {
            _impl = new ConnectivityNetworkCallback();
            ConnectivityManager cm = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
            cm.registerNetworkCallback(new NetworkRequest.Builder().build(), (ConnectivityManager.NetworkCallback)_impl);
        }
    }

    public static void unregister() {
        if (_impl != null) {
            ConnectivityManager cm = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
            cm.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)_impl);
            _impl = null;
        }
    }

    public void onAvailable(Network network) {
        ConnectivityMonitor.connected();
    }

    public void onLost(Network network) {
        ConnectivityMonitor.disconnected();
    }

    public void onCapabilitiesChanged(Network network, NetworkCapabilities capabilities) {
        ConnectivityMonitor.connectionStatusChanged();
    }

    public void onLinkPropertiesChanged(Network network, LinkProperties properties) {
        ConnectivityMonitor.connectionStatusChanged();
    }
}

