/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.IInitializationListener;
import com.unity3d.services.core.configuration.IInitializationNotificationCenter;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InitializationNotificationCenter
implements IInitializationNotificationCenter {
    private static InitializationNotificationCenter instance = null;
    private HashMap<Integer, WeakReference<IInitializationListener>> _sdkListeners = new HashMap();

    public static InitializationNotificationCenter getInstance() {
        if (instance == null) {
            instance = new InitializationNotificationCenter();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IInitializationListener listener) {
        HashMap<Integer, WeakReference<IInitializationListener>> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            if (listener != null) {
                this._sdkListeners.put(new Integer(listener.hashCode()), new WeakReference<IInitializationListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IInitializationListener listener) {
        HashMap<Integer, WeakReference<IInitializationListener>> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            if (listener != null) {
                this.removeListener(new Integer(listener.hashCode()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerOnSdkInitialized() {
        HashMap<Integer, WeakReference<IInitializationListener>> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            ArrayList<Integer> keysToRemove = new ArrayList<Integer>();
            for (Map.Entry<Integer, WeakReference<IInitializationListener>> entry : this._sdkListeners.entrySet()) {
                if (entry.getValue().get() != null) {
                    final IInitializationListener listener = (IInitializationListener)entry.getValue().get();
                    Utilities.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onSdkInitialized();
                        }
                    });
                    continue;
                }
                keysToRemove.add(entry.getKey());
            }
            for (Integer key : keysToRemove) {
                this._sdkListeners.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerOnSdkInitializationFailed(String message, final int code) {
        HashMap<Integer, WeakReference<IInitializationListener>> hashMap = this._sdkListeners;
        synchronized (hashMap) {
            final String exceptionMessage = "SDK Failed to Initialize due to " + message;
            DeviceLog.error(exceptionMessage);
            ArrayList<Integer> keysToRemove = new ArrayList<Integer>();
            for (Map.Entry<Integer, WeakReference<IInitializationListener>> entry : this._sdkListeners.entrySet()) {
                if (entry.getValue().get() != null) {
                    final IInitializationListener listener = (IInitializationListener)entry.getValue().get();
                    Utilities.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onSdkInitializationFailed(exceptionMessage, code);
                        }
                    });
                    continue;
                }
                keysToRemove.add(entry.getKey());
            }
            for (Integer key : keysToRemove) {
                this._sdkListeners.remove(key);
            }
        }
    }

    private void removeListener(Integer key) {
        this._sdkListeners.remove(key);
    }
}

