/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ar.view;

import android.annotation.TargetApi;
import android.opengl.GLES20;
import com.google.ar.core.Frame;
import com.unity3d.services.ar.view.ShaderLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class BackgroundRenderer {
    private static final int COORDS_PER_VERTEX = 3;
    private static final int TEXCOORDS_PER_VERTEX = 2;
    private static final int FLOAT_SIZE = 4;
    private FloatBuffer quadVertices;
    private FloatBuffer quadTexCoord;
    private FloatBuffer quadTexCoordTransformed;
    private int quadProgram;
    private int quadPositionParam;
    private int quadTexCoordParam;
    private int textureId = -1;
    private static final float[] QUAD_COORDS = new float[]{-1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] QUAD_TEXCOORDS = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    private static final String VERTEX_SHADER = "attribute vec4 a_Position;\nattribute vec2 a_TexCoord;\n\nvarying vec2 v_TexCoord;\n\nvoid main() {\n   gl_Position = a_Position;\n   v_TexCoord = a_TexCoord;\n}";
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 v_TexCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, v_TexCoord);\n}";

    BackgroundRenderer() {
    }

    int getTextureId() {
        return this.textureId;
    }

    @TargetApi(value=15)
    void createOnGlThread() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        this.textureId = textures[0];
        int textureTarget = 36197;
        GLES20.glBindTexture((int)textureTarget, (int)this.textureId);
        GLES20.glTexParameteri((int)textureTarget, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)textureTarget, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)textureTarget, (int)10241, (int)9728);
        GLES20.glTexParameteri((int)textureTarget, (int)10240, (int)9728);
        int numVertices = 4;
        if (numVertices != QUAD_COORDS.length / 3) {
            throw new RuntimeException("Unexpected number of vertices in BackgroundRenderer.");
        }
        ByteBuffer bbVertices = ByteBuffer.allocateDirect(QUAD_COORDS.length * 4);
        bbVertices.order(ByteOrder.nativeOrder());
        this.quadVertices = bbVertices.asFloatBuffer();
        this.quadVertices.put(QUAD_COORDS);
        this.quadVertices.position(0);
        ByteBuffer bbTexCoords = ByteBuffer.allocateDirect(numVertices * 2 * 4);
        bbTexCoords.order(ByteOrder.nativeOrder());
        this.quadTexCoord = bbTexCoords.asFloatBuffer();
        this.quadTexCoord.put(QUAD_TEXCOORDS);
        this.quadTexCoord.position(0);
        ByteBuffer bbTexCoordsTransformed = ByteBuffer.allocateDirect(numVertices * 2 * 4);
        bbTexCoordsTransformed.order(ByteOrder.nativeOrder());
        this.quadTexCoordTransformed = bbTexCoordsTransformed.asFloatBuffer();
        int vertexShader = ShaderLoader.load(VERTEX_SHADER, 35633);
        int fragmentShader = ShaderLoader.load(FRAGMENT_SHADER, 35632);
        this.quadProgram = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)this.quadProgram, (int)vertexShader);
        GLES20.glAttachShader((int)this.quadProgram, (int)fragmentShader);
        GLES20.glLinkProgram((int)this.quadProgram);
        GLES20.glUseProgram((int)this.quadProgram);
        ShaderLoader.checkGLError("Program creation");
        this.quadPositionParam = GLES20.glGetAttribLocation((int)this.quadProgram, (String)"a_Position");
        this.quadTexCoordParam = GLES20.glGetAttribLocation((int)this.quadProgram, (String)"a_TexCoord");
        ShaderLoader.checkGLError("Program parameters");
    }

    @TargetApi(value=15)
    void draw(Frame frame) {
        if (frame.hasDisplayGeometryChanged()) {
            frame.transformDisplayUvCoords(this.quadTexCoord, this.quadTexCoordTransformed);
        }
        GLES20.glDisable((int)2929);
        GLES20.glDepthMask((boolean)false);
        GLES20.glBindTexture((int)36197, (int)this.textureId);
        GLES20.glUseProgram((int)this.quadProgram);
        GLES20.glVertexAttribPointer((int)this.quadPositionParam, (int)3, (int)5126, (boolean)false, (int)0, (Buffer)this.quadVertices);
        GLES20.glVertexAttribPointer((int)this.quadTexCoordParam, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.quadTexCoordTransformed);
        GLES20.glEnableVertexAttribArray((int)this.quadPositionParam);
        GLES20.glEnableVertexAttribArray((int)this.quadTexCoordParam);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.quadPositionParam);
        GLES20.glDisableVertexAttribArray((int)this.quadTexCoordParam);
        GLES20.glDepthMask((boolean)true);
        GLES20.glEnable((int)2929);
    }
}

