/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads;

import android.app.Activity;
import android.graphics.Point;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.unity3d.ads.IUnityAdsListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.properties.AdsProperties;
import com.unity3d.services.IUnityServicesListener;
import com.unity3d.services.UnityServices;
import com.unity3d.services.ads.adunit.AdUnitOpen;
import com.unity3d.services.ads.load.LoadModule;
import com.unity3d.services.ads.placement.Placement;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import org.json.JSONException;
import org.json.JSONObject;

public final class UnityAdsImplementation {
    public static void initialize(Activity activity, String gameId, IUnityAdsListener listener) {
        boolean testMode = false;
        UnityAdsImplementation.initialize(activity, gameId, listener, testMode);
    }

    public static void initialize(Activity activity, String gameId, IUnityAdsListener listener, boolean testMode) {
        boolean usePerPlacementLoad = false;
        UnityAdsImplementation.initialize(activity, gameId, listener, testMode, usePerPlacementLoad);
    }

    public static void initialize(Activity activity, String gameId, final IUnityAdsListener listener, boolean testMode, boolean enablePerPlacementLoad) {
        DeviceLog.entered();
        UnityAdsImplementation.addListener(listener);
        UnityServices.initialize(activity, gameId, new IUnityServicesListener(){

            @Override
            public void onUnityServicesError(UnityServices.UnityServicesError error, String message) {
                if (error == UnityServices.UnityServicesError.INIT_SANITY_CHECK_FAIL) {
                    listener.onUnityAdsError(UnityAds.UnityAdsError.INIT_SANITY_CHECK_FAIL, message);
                } else if (error == UnityServices.UnityServicesError.INVALID_ARGUMENT) {
                    listener.onUnityAdsError(UnityAds.UnityAdsError.INVALID_ARGUMENT, message);
                }
            }
        }, testMode, enablePerPlacementLoad);
    }

    public static boolean isInitialized() {
        return UnityServices.isInitialized();
    }

    @Deprecated
    public static void setListener(IUnityAdsListener listener) {
        AdsProperties.setListener(listener);
    }

    @Deprecated
    public static IUnityAdsListener getListener() {
        return AdsProperties.getListener();
    }

    public static void addListener(IUnityAdsListener listener) {
        AdsProperties.addListener(listener);
    }

    public static void removeListener(IUnityAdsListener listener) {
        AdsProperties.removeListener(listener);
    }

    public static boolean isSupported() {
        return UnityServices.isSupported();
    }

    public static String getVersion() {
        return UnityServices.getVersion();
    }

    public static boolean isReady() {
        return UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && Placement.isReady();
    }

    public static boolean isReady(String placementId) {
        return UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && placementId != null && Placement.isReady(placementId);
    }

    public static UnityAds.PlacementState getPlacementState() {
        if (UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized()) {
            return Placement.getPlacementState();
        }
        return UnityAds.PlacementState.NOT_AVAILABLE;
    }

    public static UnityAds.PlacementState getPlacementState(String placementId) {
        if (UnityAdsImplementation.isSupported() && UnityAdsImplementation.isInitialized() && placementId != null) {
            return Placement.getPlacementState(placementId);
        }
        return UnityAds.PlacementState.NOT_AVAILABLE;
    }

    public static void show(Activity activity) {
        if (Placement.getDefaultPlacement() != null) {
            UnityAdsImplementation.show(activity, Placement.getDefaultPlacement());
        } else {
            UnityAdsImplementation.handleShowError("", UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads default placement is not initialized");
        }
    }

    public static void show(final Activity activity, final String placementId) {
        if (activity == null) {
            UnityAdsImplementation.handleShowError(placementId, UnityAds.UnityAdsError.INVALID_ARGUMENT, "Activity must not be null");
            return;
        }
        if (UnityAdsImplementation.isReady(placementId)) {
            DeviceLog.info("Unity Ads opening new ad unit for placement " + placementId);
            ClientProperties.setActivity(activity);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Display defaultDisplay = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
                    JSONObject options = new JSONObject();
                    try {
                        options.put("requestedOrientation", activity.getRequestedOrientation());
                        JSONObject display = new JSONObject();
                        display.put("rotation", defaultDisplay.getRotation());
                        if (Build.VERSION.SDK_INT >= 13) {
                            Point displaySize = new Point();
                            defaultDisplay.getSize(displaySize);
                            display.put("width", displaySize.x);
                            display.put("height", displaySize.y);
                        } else {
                            display.put("width", defaultDisplay.getWidth());
                            display.put("height", defaultDisplay.getHeight());
                        }
                        options.put("display", (Object)display);
                    }
                    catch (JSONException e) {
                        DeviceLog.exception("JSON error while constructing show options", (Exception)((Object)e));
                    }
                    try {
                        if (!AdUnitOpen.open(placementId, options)) {
                            UnityAdsImplementation.handleShowError(placementId, UnityAds.UnityAdsError.INTERNAL_ERROR, "Webapp timeout, shutting down Unity Ads");
                        }
                    }
                    catch (NoSuchMethodException exception) {
                        DeviceLog.exception("Could not get callback method", exception);
                        UnityAdsImplementation.handleShowError(placementId, UnityAds.UnityAdsError.SHOW_ERROR, "Could not get com.unity3d.ads.properties.showCallback method");
                    }
                }
            }).start();
        } else if (!UnityAdsImplementation.isSupported()) {
            UnityAdsImplementation.handleShowError(placementId, UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads is not supported for this device");
        } else if (!UnityAdsImplementation.isInitialized()) {
            UnityAdsImplementation.handleShowError(placementId, UnityAds.UnityAdsError.NOT_INITIALIZED, "Unity Ads is not initialized");
        } else {
            UnityAdsImplementation.handleShowError(placementId, UnityAds.UnityAdsError.SHOW_ERROR, "Placement \"" + placementId + "\" is not ready");
        }
    }

    private static void handleShowError(final String placementId, final UnityAds.UnityAdsError error, String message) {
        final String errorMessage = "Unity Ads show failed: " + message;
        DeviceLog.error(errorMessage);
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (IUnityAdsListener listener : AdsProperties.getListeners()) {
                    listener.onUnityAdsError(error, errorMessage);
                    if (placementId != null) {
                        listener.onUnityAdsFinish(placementId, UnityAds.FinishState.ERROR);
                        continue;
                    }
                    listener.onUnityAdsFinish("", UnityAds.FinishState.ERROR);
                }
            }
        });
    }

    public static void setDebugMode(boolean debugMode) {
        UnityServices.setDebugMode(debugMode);
    }

    public static boolean getDebugMode() {
        return UnityServices.getDebugMode();
    }

    public static String getDefaultPlacement() {
        return Placement.getDefaultPlacement();
    }

    public static void load(String placementId) {
        LoadModule.getInstance().load(placementId);
    }
}

