/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.interceptor;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.Header;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import com.unfbx.chatgpt.function.KeyStrategyFunction;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;

public abstract class OpenAiAuthInterceptor
implements Interceptor {
    private List<String> apiKey;
    private KeyStrategyFunction<List<String>, String> keyStrategy;
    private Map warringConfig;

    protected abstract List<String> onErrorDealApiKeys(String var1);

    protected abstract void noHaveActiveKeyWarring();

    public final String getKey() {
        if (CollectionUtil.isEmpty(this.apiKey)) {
            this.noHaveActiveKeyWarring();
            throw new BaseException(CommonError.NO_ACTIVE_API_KEYS);
        }
        return this.keyStrategy.apply(this.apiKey);
    }

    public Request auth(String key, Request original) {
        return original.newBuilder().header(Header.AUTHORIZATION.getValue(), "Bearer " + key).header(Header.CONTENT_TYPE.getValue(), ContentType.JSON.getValue()).method(original.method(), original.body()).build();
    }

    public List<String> getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(List<String> apiKey) {
        this.apiKey = apiKey;
    }

    public KeyStrategyFunction<List<String>, String> getKeyStrategy() {
        return this.keyStrategy;
    }

    public void setKeyStrategy(KeyStrategyFunction<List<String>, String> keyStrategy) {
        this.keyStrategy = keyStrategy;
    }

    public Map getWarringConfig() {
        return this.warringConfig;
    }

    public void setWarringConfig(Map warringConfig) {
        this.warringConfig = warringConfig;
    }
}

