/*
 * Decompiled with CFR 0.152.
 */
package com.underlegendz.underactivity;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.tabs.TabLayout;
import com.underlegendz.underactivity.ActivityBuilder;
import com.underlegendz.underactivity.UnderActivityBind;

class ConfigureToolbar {
    ConfigureToolbar() {
    }

    static void configureToolbar(ActivityBuilder builder, AppCompatActivity activity, ViewGroup content) {
        AppBarLayout appBarLayout;
        Toolbar toolbarView = null;
        if (builder.appBarLayout != null || builder.appBarLayoutResource != null) {
            appBarLayout = builder.appBarLayout;
            if (appBarLayout == null) {
                appBarLayout = (AppBarLayout)activity.getLayoutInflater().inflate(builder.appBarLayoutResource.intValue(), content, false);
            }
            content.addView((View)appBarLayout);
            if (activity instanceof UnderActivityBind) {
                for (int i = 0; i < appBarLayout.getChildCount(); ++i) {
                    View childView = appBarLayout.getChildAt(i);
                    if (childView instanceof Toolbar) {
                        toolbarView = (Toolbar)childView;
                        ((UnderActivityBind)activity).bindToolbar((Toolbar)childView);
                        continue;
                    }
                    if (!(childView instanceof TabLayout)) continue;
                    ((UnderActivityBind)activity).bindTabLayout((TabLayout)childView);
                }
            }
        } else {
            AppBarLayout.LayoutParams appBarLayoutParams;
            toolbarView = builder.toolbarResource != null ? (Toolbar)activity.getLayoutInflater().inflate(builder.toolbarResource.intValue(), content, false) : builder.toolbar;
            if (toolbarView == null) {
                toolbarView = new Toolbar((Context)activity);
            }
            if (activity instanceof UnderActivityBind) {
                ((UnderActivityBind)activity).bindToolbar(toolbarView);
            }
            appBarLayout = new AppBarLayout((Context)activity);
            CoordinatorLayout.LayoutParams coordinatorLayoutParams = new CoordinatorLayout.LayoutParams(-1, -2);
            appBarLayout.setLayoutParams((ViewGroup.LayoutParams)coordinatorLayoutParams);
            if (toolbarView.getLayoutParams() != null) {
                appBarLayoutParams = new AppBarLayout.LayoutParams(toolbarView.getLayoutParams());
                appBarLayoutParams.width = -1;
            } else {
                appBarLayoutParams = new AppBarLayout.LayoutParams(-1, -2);
            }
            appBarLayoutParams.setScrollFlags(builder.toolbarScrollFlags);
            toolbarView.setLayoutParams((ViewGroup.LayoutParams)appBarLayoutParams);
            appBarLayout.addView((View)toolbarView);
            if (builder.enableToolbarTabs) {
                TabLayout tabLayout = builder.tabLayoutResource != null ? (TabLayout)activity.getLayoutInflater().inflate(builder.tabLayoutResource.intValue(), content, false) : builder.tabLayoutView;
                if (tabLayout == null) {
                    tabLayout = new TabLayout((Context)activity);
                }
                AppBarLayout.LayoutParams appBarLayoutParams_TabLayout = new AppBarLayout.LayoutParams(-1, -2);
                appBarLayoutParams_TabLayout.setScrollFlags(0);
                tabLayout.setLayoutParams((ViewGroup.LayoutParams)appBarLayoutParams_TabLayout);
                if (builder.toolbarTabLayoutBackgroundColor != null) {
                    tabLayout.setBackgroundColor(builder.toolbarTabLayoutBackgroundColor.intValue());
                } else if (builder.toolbarBackgroundColor != null) {
                    tabLayout.setBackgroundColor(builder.toolbarBackgroundColor.intValue());
                }
                appBarLayout.addView((View)tabLayout);
                if (activity instanceof UnderActivityBind) {
                    ((UnderActivityBind)activity).bindTabLayout(tabLayout);
                }
            }
            coordinatorLayoutParams.setBehavior((CoordinatorLayout.Behavior)new AppBarLayout.Behavior());
            appBarLayout.setLayoutParams((ViewGroup.LayoutParams)coordinatorLayoutParams);
            content.addView((View)appBarLayout, 0);
        }
        if (toolbarView != null) {
            if (builder.toolbarPopupTheme != null) {
                toolbarView.setPopupTheme(builder.toolbarPopupTheme.intValue());
            }
            if (builder.toolbarBackgroundColor != null) {
                toolbarView.setBackgroundColor(builder.toolbarBackgroundColor.intValue());
            }
            if (builder.toolbarTitleColor != null) {
                toolbarView.setTitleTextColor(builder.toolbarTitleColor.intValue());
            }
            activity.setSupportActionBar(toolbarView);
            ActionBar ab = activity.getSupportActionBar();
            if (ab != null) {
                if (builder.toolbarBack) {
                    if (builder.toolbarBackIcon != null) {
                        ab.setHomeAsUpIndicator(builder.toolbarBackIcon.intValue());
                    }
                    ab.setDisplayHomeAsUpEnabled(true);
                    if (activity instanceof UnderActivityBind) {
                        ((UnderActivityBind)activity).goBackOnHome(true);
                    }
                } else if (builder.toolbarDrawerIcon != null) {
                    ab.setHomeAsUpIndicator(builder.toolbarDrawerIcon.intValue());
                    ab.setDisplayHomeAsUpEnabled(true);
                }
            }
        }
    }
}

