/*
 * Decompiled with CFR 0.152.
 */
package com.underlegendz.underactivity;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.drawerlayout.widget.DrawerLayout;
import com.underlegendz.underactivity.ActivityBuilder;
import com.underlegendz.underactivity.ConfigureContent;
import com.underlegendz.underactivity.ConfigureDrawer;
import com.underlegendz.underactivity.ConfigureToolbar;
import com.underlegendz.underactivity.UnderActivityBind;

public class ActivityRender {
    public static void render(AppCompatActivity activity, ActivityBuilder builder) {
        if (builder.enableFullScreenMode) {
            activity.requestWindowFeature(1);
            activity.getWindow().setFlags(1024, 1024);
        }
        DrawerLayout drawerLayout = null;
        if (builder.enableDrawer) {
            drawerLayout = new DrawerLayout((Context)activity);
            if (activity instanceof UnderActivityBind) {
                ((UnderActivityBind)activity).bindDrawerLayout(drawerLayout);
            }
            activity.setContentView((View)drawerLayout);
            ConfigureDrawer.configureDrawer(builder, (Activity)activity, drawerLayout);
        }
        CoordinatorLayout content = new CoordinatorLayout((Context)activity);
        if (drawerLayout != null) {
            content.setLayoutParams((ViewGroup.LayoutParams)ActivityRender.getDrawerLayoutParams());
            drawerLayout.addView((View)content, 0);
        } else {
            activity.setContentView((View)content);
        }
        if (builder.enableToolbar) {
            ConfigureToolbar.configureToolbar(builder, activity, (ViewGroup)content);
        }
        ConfigureContent.configureContent(builder, (Activity)activity, (ViewGroup)content);
    }

    @NonNull
    static DrawerLayout.LayoutParams getDrawerLayoutParams() {
        return new DrawerLayout.LayoutParams(-1, -1);
    }

    @NonNull
    static CoordinatorLayout.LayoutParams getCoordinatorLayoutParams() {
        return new CoordinatorLayout.LayoutParams(-1, -1);
    }
}

